/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.ci.job.OpenProfileJob;
import info.novatec.inspectit.rcp.ci.listener.IProfileChangeListener;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.filter.FilterComposite;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProfileSelectionPart
extends SectionPart
implements IProfileChangeListener,
IPropertyListener {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private Environment environment;
    private List<Profile> profiles;
    private FormPage formPage;
    private TableViewer tableViewer;

    public ProfileSelectionPart(FormPage formPage, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)formPage.getEditor().getEditorInput();
        this.cmrRepositoryDefinition = environmentEditorInput.getCmrRepositoryDefinition();
        this.environment = environmentEditorInput.getEnvironment();
        this.profiles = new ArrayList<Profile>(environmentEditorInput.getProfiles());
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.createClient(this.getSection(), formToolkit);
        this.getSection().setText("Profiles");
        Label label = formToolkit.createLabel((Composite)this.getSection(), "Select profiles to use within environment");
        label.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.getSection().setDescriptionControl((Control)label);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addProfileChangeListener(this);
    }

    private void createClient(Section section, FormToolkit formToolkit) {
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(1, true));
        section.setClient((Control)composite);
        FilterProfileComposite filterProfileComposite = new FilterProfileComposite(composite, 0);
        filterProfileComposite.setLayoutData(new GridData(4, 4, true, false));
        formToolkit.adapt((Composite)filterProfileComposite);
        Table table = formToolkit.createTable(composite, 68388);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof Profile && object2 instanceof Profile) {
                    int n = Boolean.compare(((Profile)object).isCommonProfile(), ((Profile)object2).isCommonProfile());
                    if (n != 0) {
                        return n;
                    }
                    return ((Profile)object).getName().compareToIgnoreCase(((Profile)object2).getName());
                }
                return 0;
            }
        });
        this.tableViewer.setInput(this.profiles);
        this.tableViewer.refresh();
        this.updateCheckedItems();
        this.tableViewer.addFilter(filterProfileComposite.getFilter());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 32 && !ProfileSelectionPart.this.isDirty()) {
                    ProfileSelectionPart.this.markDirty();
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new EditProfileAction());
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void createColumns() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.getColumn().setWidth(40);
        tableViewerColumn.getColumn().setText("Selected");
        tableViewerColumn.getColumn().setToolTipText("If profile is included in the Environment.");
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(250);
        tableViewerColumn2.getColumn().setText("Profile");
        tableViewerColumn2.getColumn().setToolTipText("Profile name.");
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn3.getColumn().setMoveable(true);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.getColumn().setText("Active");
        tableViewerColumn3.getColumn().setWidth(60);
        tableViewerColumn3.getColumn().setToolTipText("If profile is active or not, note that deactivated profile will not be considered during the instrumentation even if it's a part of an Environment.");
        TableViewerColumn tableViewerColumn4 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn4.getColumn().setMoveable(true);
        tableViewerColumn4.getColumn().setResizable(true);
        tableViewerColumn4.getColumn().setText("Default");
        tableViewerColumn4.getColumn().setWidth(60);
        tableViewerColumn4.getColumn().setToolTipText("If profile is default or not, note that default profile will be added to any new created Environment.");
        TableViewerColumn tableViewerColumn5 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn5.getColumn().setMoveable(true);
        tableViewerColumn5.getColumn().setResizable(true);
        tableViewerColumn5.getColumn().setText("Description");
        tableViewerColumn5.getColumn().setWidth(150);
        tableViewerColumn5.getColumn().setToolTipText("Profile description.");
    }

    private void updateCheckedItems() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Profile profile = (Profile)tableItem.getData();
            tableItem.setChecked(this.environment.getProfileIds().contains(profile.getId()));
            ++n2;
        }
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            HashSet<String> hashSet = new HashSet<String>(1);
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (tableItem.getChecked()) {
                    hashSet.add(((Profile)tableItem.getData()).getId());
                }
                ++n2;
            }
            this.environment.setProfileIds(hashSet);
        }
    }

    @Override
    public void profileCreated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        CmrRepositoryDefinition cmrRepositoryDefinition2 = ((EnvironmentEditorInput)this.formPage.getEditor().getEditorInput()).getCmrRepositoryDefinition();
        if (!Objects.equals(cmrRepositoryDefinition, cmrRepositoryDefinition2)) {
            return;
        }
        this.profiles.add(profile);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProfileSelectionPart.this.tableViewer.refresh();
                ProfileSelectionPart.this.updateCheckedItems();
            }
        });
    }

    @Override
    public void profileUpdated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        CmrRepositoryDefinition cmrRepositoryDefinition2 = ((EnvironmentEditorInput)this.formPage.getEditor().getEditorInput()).getCmrRepositoryDefinition();
        if (!Objects.equals(cmrRepositoryDefinition, cmrRepositoryDefinition2)) {
            return;
        }
        Iterator<Profile> iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            Profile profile2 = iterator.next();
            if (!Objects.equals(profile2.getId(), profile.getId())) continue;
            iterator.remove();
            this.profiles.add(profile);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfileSelectionPart.this.tableViewer.refresh();
                    ProfileSelectionPart.this.updateCheckedItems();
                }
            });
            break;
        }
    }

    @Override
    public void profileDeleted(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        CmrRepositoryDefinition cmrRepositoryDefinition2 = ((EnvironmentEditorInput)this.formPage.getEditor().getEditorInput()).getCmrRepositoryDefinition();
        if (!Objects.equals(cmrRepositoryDefinition, cmrRepositoryDefinition2)) {
            return;
        }
        Iterator<Profile> iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            final Profile profile2 = iterator.next();
            if (!Objects.equals(profile2.getId(), profile.getId())) continue;
            iterator.remove();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfileSelectionPart.this.tableViewer.remove((Object)profile2);
                }
            });
            break;
        }
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.formPage.getEditor().getEditorInput();
            this.environment = environmentEditorInput.getEnvironment();
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeProfileChangeListener(this);
        super.dispose();
    }

    private class EditProfileAction
    extends Action {
        public EditProfileAction() {
            this.setText("Edit");
            this.setToolTipText("Edit Profile");
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)ProfileSelectionPart.this.tableViewer.getSelection();
            if (!structuredSelection.isEmpty()) {
                Profile profile = (Profile)structuredSelection.getFirstElement();
                new OpenProfileJob(ProfileSelectionPart.this.cmrRepositoryDefinition, profile.getId(), ProfileSelectionPart.this.formPage.getSite().getPage()).schedule();
            }
        }
    }

    private class FilterProfileComposite
    extends FilterComposite {
        private String filterString;
        private ViewerFilter filter;

        public FilterProfileComposite(Composite composite, int n) {
            super(composite, n, "Filter profiles");
            this.filterString = "";
            this.filter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object object, Object object2) {
                    if (Objects.equals("", FilterProfileComposite.this.filterString)) {
                        return true;
                    }
                    if (object2 instanceof Profile) {
                        return this.select((Profile)object2);
                    }
                    return true;
                }

                private boolean select(Profile profile) {
                    return StringUtils.containsIgnoreCase((String)profile.getName(), (String)FilterProfileComposite.this.filterString);
                }
            };
            ((GridLayout)this.getLayout()).marginWidth = 0;
        }

        @Override
        protected void executeCancel() {
            this.filterString = "";
            ProfileSelectionPart.this.tableViewer.refresh();
            ProfileSelectionPart.this.updateCheckedItems();
        }

        @Override
        protected void executeFilter(String string) {
            this.filterString = string;
            ProfileSelectionPart.this.tableViewer.refresh();
            ProfileSelectionPart.this.updateCheckedItems();
        }

        public ViewerFilter getFilter() {
            return this.filter;
        }
    }

    private static class ProfileLabelProvider
    extends StyledCellIndexLabelProvider {
        private static final StyledString EMPTY = new StyledString();

        private ProfileLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            if (object instanceof Profile) {
                Profile profile = (Profile)object;
                switch (n) {
                    case 1: {
                        return new StyledString(profile.getName());
                    }
                    case 4: {
                        return TextFormatter.emptyStyledStringIfNull(TextFormatter.clearLineBreaks(profile.getDescription()));
                    }
                }
                return EMPTY;
            }
            return EMPTY;
        }

        @Override
        protected Image getColumnImage(Object object, int n) {
            if (object instanceof Profile) {
                Profile profile = (Profile)object;
                switch (n) {
                    case 1: {
                        return ImageFormatter.getProfileImage(profile);
                    }
                    case 2: {
                        return profile.isActive() ? InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif") : null;
                    }
                    case 3: {
                        return profile.isDefaultProfile() ? InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif") : null;
                    }
                }
                return super.getColumnImage(object, n);
            }
            return super.getColumnImage(object, n);
        }

        @Override
        protected Color getForeground(Object object, int n) {
            Profile profile;
            if (object instanceof Profile && (profile = (Profile)object).isCommonProfile()) {
                return Display.getCurrent().getSystemColor(14);
            }
            return super.getForeground(object, n);
        }
    }
}

