/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.platform.AbstractPlatformSensorConfig;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlatformSensorSelectionPart
extends SectionPart
implements IPropertyListener {
    private Environment environment;
    private TableViewer tableViewer;
    private FormPage formPage;

    public PlatformSensorSelectionPart(FormPage formPage, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)formPage.getEditor().getEditorInput();
        this.environment = environmentEditorInput.getEnvironment();
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.createClient(this.getSection(), formToolkit);
        this.getSection().setText("Platform Sensors");
        Label label = formToolkit.createLabel((Composite)this.getSection(), "Select platform sensor to be active within environment");
        label.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.getSection().setDescriptionControl((Control)label);
    }

    private void createClient(Section section, FormToolkit formToolkit) {
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(1, true));
        section.setClient((Control)composite);
        Table table = formToolkit.createTable(composite, 68386);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput((Object)this.environment.getPlatformSensorConfigs());
        this.tableViewer.refresh();
        this.updateCheckedItems();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 32 && !PlatformSensorSelectionPart.this.isDirty()) {
                    PlatformSensorSelectionPart.this.markDirty();
                }
            }
        });
    }

    private void createColumns() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.getColumn().setWidth(60);
        tableViewerColumn.getColumn().setText("Active");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return "";
            }
        });
        tableViewerColumn.getColumn().setToolTipText("If sensor is active then it is sending monitoring data.");
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(250);
        tableViewerColumn2.getColumn().setText("Sensor");
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return TextFormatter.getSensorConfigName((ISensorConfig)object);
            }

            public Image getImage(Object object) {
                return ImageFormatter.getSensorConfigImage((ISensorConfig)object);
            }
        });
        tableViewerColumn2.getColumn().setToolTipText("Sensor type.");
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                AbstractPlatformSensorConfig abstractPlatformSensorConfig = (AbstractPlatformSensorConfig)tableItem.getData();
                abstractPlatformSensorConfig.setActive(tableItem.getChecked());
                ++n2;
            }
        }
    }

    private void updateCheckedItems() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            AbstractPlatformSensorConfig abstractPlatformSensorConfig = (AbstractPlatformSensorConfig)tableItem.getData();
            tableItem.setChecked(abstractPlatformSensorConfig.isActive());
            ++n2;
        }
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.formPage.getEditor().getEditorInput();
            this.environment = environmentEditorInput.getEnvironment();
            this.tableViewer.setInput((Object)this.environment.getPlatformSensorConfigs());
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        super.dispose();
    }
}

