/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.part.AbstractClassSensorAssignmentDetailsPage;
import info.novatec.inspectit.rcp.ci.form.part.ISensorAssignmentUpdateListener;
import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import info.novatec.inspectit.rcp.validation.validator.FqnWildcardValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MethodSensorAssignmentDetailsPage
extends AbstractClassSensorAssignmentDetailsPage {
    private MethodSensorAssignment assignment;
    private List<String> parametersList = new ArrayList<String>();
    private Text methodText;
    private Button methodButton;
    private Button constructorButton;
    private TableViewer parametersTableViewer;
    private Button parametersButton;
    private Button addParameterButton;
    private Button removeParameterButton;
    private Button publicButton;
    private Button protectedButton;
    private Button privateButton;
    private Button defaultButton;

    public MethodSensorAssignmentDetailsPage(ISensorAssignmentUpdateListener iSensorAssignmentUpdateListener, boolean bl) {
        super(iSensorAssignmentUpdateListener, bl);
    }

    protected MethodSensorAssignment getInput() {
        return this.assignment;
    }

    @Override
    public void createContents(Composite composite) {
        this.createContents(composite, true);
    }

    protected void createContents(Composite composite, boolean bl) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 5;
        tableWrapLayout.leftMargin = 5;
        tableWrapLayout.rightMargin = 2;
        tableWrapLayout.bottomMargin = 2;
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)tableWrapLayout);
        FormToolkit formToolkit = this.managedForm.getToolkit();
        FormText formText = this.createTitle(composite, formToolkit);
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.colspan = 2;
        formText.setLayoutData((Object)tableWrapData);
        Section section = formToolkit.createSection(composite, 320);
        section.setText("Method definition");
        section.marginWidth = 10;
        section.marginHeight = 5;
        TableWrapData tableWrapData2 = new TableWrapData(128, 16);
        tableWrapData2.grabHorizontal = true;
        section.setLayoutData((Object)tableWrapData2);
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        this.addClassContents(composite2);
        this.addMethodContents(composite2);
        if (bl) {
            tableWrapData = new TableWrapData();
            tableWrapData.grabHorizontal = true;
            formToolkit.createLabel(composite, "", 0).setLayoutData((Object)tableWrapData);
        }
        if (!this.isCanEdit()) {
            this.setEnabled(composite2, false);
        }
    }

    protected void addMethodContents(Composite composite) {
        FormToolkit formToolkit = this.managedForm.getToolkit();
        formToolkit.createLabel(composite, "Method:");
        this.methodButton = formToolkit.createButton(composite, "Method name", 16);
        this.methodButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.methodText = formToolkit.createText(composite, "", 2048);
        this.methodText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        formToolkit.createLabel(composite, "");
        this.createInfoLabel(composite, formToolkit, "The name of the method to be monitored. The wild-card * can be used to match any length of characters.");
        formToolkit.createLabel(composite, "");
        this.constructorButton = formToolkit.createButton(composite, "Constructor", 16);
        this.constructorButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        formToolkit.createLabel(composite, "").setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        final ValidationControlDecoration<Text> validationControlDecoration = new ValidationControlDecoration<Text>(this.methodText, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                return StringUtils.isNotEmpty((String)text.getText());
            }
        };
        validationControlDecoration.setDescriptionText("Method name must not be empty. Use wildcard * to match any method.");
        validationControlDecoration.registerListener(24);
        this.addValidationControlDecoration(validationControlDecoration);
        this.methodButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodSensorAssignmentDetailsPage.this.methodText.setEnabled(MethodSensorAssignmentDetailsPage.this.methodButton.getSelection());
                if (!MethodSensorAssignmentDetailsPage.this.methodButton.getSelection()) {
                    MethodSensorAssignmentDetailsPage.this.methodText.setText("");
                }
                validationControlDecoration.executeValidation();
            }
        });
        formToolkit.createLabel(composite, "Parameters:");
        this.parametersButton = formToolkit.createButton(composite, "Only method/constructor with selected parameters", 32);
        this.parametersButton.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        formToolkit.createLabel(composite, "");
        this.createInfoLabel(composite, formToolkit, "Restriction of the method or constructor. Only the method/constructor with specified fully qualified parameter names is monitored. For primitive type parameters use primitive names like boolean, int, long, etc. Use wildcard * to match any parameter.");
        formToolkit.createLabel(composite, "");
        final Table table = formToolkit.createTable(composite, 268503812);
        GridData gridData = new GridData(4, 4, false, false, 4, 1);
        gridData.heightHint = 120;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        this.parametersTableViewer = new TableViewer(table);
        this.parametersTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.parametersTableViewer.setInput(this.parametersList);
        this.createColumnsForParametersTable();
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new GridData(4, 128, false, false));
        composite2.setLayout((Layout)new FillLayout(512));
        this.addParameterButton = formToolkit.createButton(composite2, "", 8);
        this.addParameterButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/add_obj.gif"));
        this.removeParameterButton = formToolkit.createButton(composite2, "", 8);
        this.removeParameterButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_correction.gif"));
        formToolkit.createLabel(composite, "");
        this.parametersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = MethodSensorAssignmentDetailsPage.this.parametersButton.getSelection();
                table.setEnabled(bl);
                MethodSensorAssignmentDetailsPage.this.addParameterButton.setEnabled(bl);
                MethodSensorAssignmentDetailsPage.this.removeParameterButton.setEnabled(bl);
            }
        });
        this.addParameterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InputDialog inputDialog = new InputDialog(MethodSensorAssignmentDetailsPage.this.managedForm.getForm().getShell(), "Add Parameter", "Specify fully qualified parameter name:", "", (IInputValidator)new FqnWildcardValidator(false, true));
                if (inputDialog.open() == 0 && StringUtils.isNotBlank((String)inputDialog.getValue())) {
                    MethodSensorAssignmentDetailsPage.this.parametersList.add(inputDialog.getValue());
                    MethodSensorAssignmentDetailsPage.this.parametersTableViewer.refresh();
                    MethodSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                }
            }
        });
        this.removeParameterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StructuredSelection structuredSelection = (StructuredSelection)MethodSensorAssignmentDetailsPage.this.parametersTableViewer.getSelection();
                if (!structuredSelection.isEmpty()) {
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        MethodSensorAssignmentDetailsPage.this.parametersList.remove(object);
                        ++n2;
                    }
                    MethodSensorAssignmentDetailsPage.this.parametersTableViewer.refresh();
                    MethodSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                }
            }
        });
        this.parametersTableViewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                StructuredSelection structuredSelection = (StructuredSelection)MethodSensorAssignmentDetailsPage.this.parametersTableViewer.getSelection();
                if (!structuredSelection.isEmpty()) {
                    String string = (String)structuredSelection.getFirstElement();
                    InputDialog inputDialog = new InputDialog(MethodSensorAssignmentDetailsPage.this.managedForm.getForm().getShell(), "Edit Parameter", "Specify fully qualified parameter name:", string, null);
                    if (inputDialog.open() == 0 && StringUtils.isNotBlank((String)inputDialog.getValue())) {
                        String string2 = inputDialog.getValue();
                        int n = 0;
                        int n2 = 0;
                        while (n2 < MethodSensorAssignmentDetailsPage.this.parametersList.size()) {
                            if (string == MethodSensorAssignmentDetailsPage.this.parametersList.get(n2)) {
                                n = n2;
                                break;
                            }
                            ++n2;
                        }
                        MethodSensorAssignmentDetailsPage.this.parametersList.remove(n);
                        MethodSensorAssignmentDetailsPage.this.parametersList.add(n, string2);
                        MethodSensorAssignmentDetailsPage.this.parametersTableViewer.refresh();
                        MethodSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                    }
                }
            }
        });
        formToolkit.createLabel(composite, "Method visibility:");
        this.publicButton = formToolkit.createButton(composite, "public", 32);
        this.publicButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.protectedButton = formToolkit.createButton(composite, "protected", 32);
        this.protectedButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.defaultButton = formToolkit.createButton(composite, "default", 32);
        this.defaultButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.privateButton = formToolkit.createButton(composite, "private", 32);
        this.privateButton.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.createLabel(composite, "");
        this.createInfoLabel(composite, formToolkit, "The additional options of the sensor assignment can include the definition of the method/constructor visibility modifier(s) that should be instrumented. Thus, the methods can be additionally filtered by the visibility modifier that can be: public, protected, private or default");
        ValidationControlDecoration<Button> validationControlDecoration2 = new ValidationControlDecoration<Button>(this.publicButton, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(Button button) {
                return MethodSensorAssignmentDetailsPage.this.publicButton.getSelection() || MethodSensorAssignmentDetailsPage.this.protectedButton.getSelection() || MethodSensorAssignmentDetailsPage.this.defaultButton.getSelection() || MethodSensorAssignmentDetailsPage.this.privateButton.getSelection();
            }
        };
        validationControlDecoration2.setDescriptionText("At least one type of modifiers must be selected.");
        validationControlDecoration2.registerListener((Control)this.publicButton, 13);
        validationControlDecoration2.registerListener((Control)this.protectedButton, 13);
        validationControlDecoration2.registerListener((Control)this.defaultButton, 13);
        validationControlDecoration2.registerListener((Control)this.privateButton, 13);
        this.addValidationControlDecoration(validationControlDecoration2);
        this.methodButton.addListener(13, this.getMarkDirtyListener());
        this.methodText.addListener(24, this.getMarkDirtyListener());
        this.parametersButton.addListener(13, this.getMarkDirtyListener());
        this.publicButton.addListener(13, this.getMarkDirtyListener());
        this.protectedButton.addListener(13, this.getMarkDirtyListener());
        this.defaultButton.addListener(13, this.getMarkDirtyListener());
        this.privateButton.addListener(13, this.getMarkDirtyListener());
    }

    private void createColumnsForParametersTable() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.parametersTableViewer, 0);
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setWidth(100);
        tableViewerColumn.getColumn().setText("Parameter FQN");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return (String)object;
            }
        });
        tableViewerColumn.getColumn().setToolTipText("Parameter FQN or primitive type name.");
    }

    @Override
    protected void updateFromInput() {
        super.updateFromInput();
        this.methodText.setEnabled(false);
        this.methodText.setText("");
        this.methodButton.setSelection(false);
        this.constructorButton.setSelection(false);
        this.parametersButton.setSelection(false);
        this.parametersList.clear();
        this.publicButton.setSelection(false);
        this.protectedButton.setSelection(false);
        this.privateButton.setSelection(false);
        this.defaultButton.setSelection(false);
        MethodSensorAssignment methodSensorAssignment = this.getInput();
        if (methodSensorAssignment != null) {
            if (methodSensorAssignment.isConstructor()) {
                this.constructorButton.setSelection(true);
            } else {
                this.methodText.setEnabled(this.isCanEdit());
                this.methodText.setText(this.getEmptyIfNull(methodSensorAssignment.getMethodName()));
                this.methodButton.setSelection(true);
            }
            if (methodSensorAssignment.getParameters() != null) {
                this.parametersButton.setSelection(true);
                this.parametersTableViewer.getTable().setEnabled(this.isCanEdit());
                this.addParameterButton.setEnabled(this.isCanEdit());
                this.removeParameterButton.setEnabled(this.isCanEdit());
                for (String string : methodSensorAssignment.getParameters()) {
                    this.parametersList.add(string);
                }
            } else {
                this.parametersTableViewer.getTable().setEnabled(false);
                this.addParameterButton.setEnabled(false);
                this.removeParameterButton.setEnabled(false);
            }
            this.publicButton.setSelection(methodSensorAssignment.isPublicModifier());
            this.protectedButton.setSelection(methodSensorAssignment.isProtectedModifier());
            this.privateButton.setSelection(methodSensorAssignment.isPrivateModifier());
            this.defaultButton.setSelection(methodSensorAssignment.isDefaultModifier());
        }
        this.parametersTableViewer.refresh();
    }

    @Override
    protected void commitToInput() {
        super.commitToInput();
        MethodSensorAssignment methodSensorAssignment = this.getInput();
        if (methodSensorAssignment != null) {
            methodSensorAssignment.setConstructor(this.constructorButton.getSelection());
            if (!methodSensorAssignment.isConstructor()) {
                methodSensorAssignment.setMethodName(this.methodText.getText());
            } else {
                methodSensorAssignment.setMethodName(null);
            }
            if (this.parametersButton.getSelection()) {
                methodSensorAssignment.setParameters(new ArrayList<String>(this.parametersList));
            } else {
                methodSensorAssignment.setParameters(null);
            }
            methodSensorAssignment.setPublicModifier(this.publicButton.getSelection());
            methodSensorAssignment.setProtectedModifier(this.protectedButton.getSelection());
            methodSensorAssignment.setPrivateModifier(this.privateButton.getSelection());
            methodSensorAssignment.setDefaultModifier(this.defaultButton.getSelection());
        }
    }

    @Override
    protected void setInput(ISelection iSelection) {
        this.assignment = !iSelection.isEmpty() ? (MethodSensorAssignment)((IStructuredSelection)iSelection).getFirstElement() : null;
    }
}

