/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.assignment.AbstractClassSensorAssignment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.part.ISensorAssignmentUpdateListener;
import info.novatec.inspectit.rcp.ci.form.part.SensorAssignmentMasterBlock;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import info.novatec.inspectit.rcp.validation.InputValidatorControlDecoration;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import info.novatec.inspectit.rcp.validation.validator.FqnWildcardValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractClassSensorAssignmentDetailsPage
implements IDetailsPage,
IControlValidationListener {
    private final ISensorAssignmentUpdateListener masterBlockListener;
    private boolean canEdit;
    private boolean updateInProgress;
    private boolean valid;
    private List<ValidationControlDecoration<?>> validationControlDecorations = new ArrayList();
    protected IManagedForm managedForm;
    protected Listener markDirtyListener = new Listener(){

        public void handleEvent(Event event) {
            if (!AbstractClassSensorAssignmentDetailsPage.this.updateInProgress) {
                AbstractClassSensorAssignmentDetailsPage.this.commitToInput();
                AbstractClassSensorAssignment<?> abstractClassSensorAssignment = AbstractClassSensorAssignmentDetailsPage.this.getInput();
                if (AbstractClassSensorAssignmentDetailsPage.this.masterBlockListener != null && abstractClassSensorAssignment != null) {
                    AbstractClassSensorAssignmentDetailsPage.this.masterBlockListener.sensorAssignmentUpdated(abstractClassSensorAssignment, true, AbstractClassSensorAssignmentDetailsPage.this.isValid(), AbstractClassSensorAssignmentDetailsPage.this.validationControlDecorations);
                }
            }
        }
    };
    private Button interfaceButton;
    private Button superclassButton;
    private Text classText;
    private Button classSearchButton;
    private Text annotationText;
    private Button annotationSearchButton;
    private FormText title;

    public AbstractClassSensorAssignmentDetailsPage(ISensorAssignmentUpdateListener iSensorAssignmentUpdateListener, boolean bl) {
        this.masterBlockListener = iSensorAssignmentUpdateListener;
        this.canEdit = bl;
    }

    protected abstract AbstractClassSensorAssignment<?> getInput();

    protected abstract void setInput(ISelection var1);

    public void initialize(IManagedForm iManagedForm) {
        this.managedForm = iManagedForm;
    }

    public void createContents(Composite composite) {
        FormToolkit formToolkit = this.managedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 320);
        section.setText("Class definition");
        section.marginWidth = 10;
        section.marginHeight = 5;
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        section.setLayoutData((Object)tableWrapData);
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        this.addClassContents(composite2);
        if (!this.isCanEdit()) {
            this.setEnabled(composite2, false);
        }
    }

    protected void addClassContents(Composite composite) {
        FormToolkit formToolkit = this.managedForm.getToolkit();
        formToolkit.createLabel(composite, "");
        this.interfaceButton = formToolkit.createButton(composite, "Interface", 32);
        this.interfaceButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.superclassButton = formToolkit.createButton(composite, "Superclass", 32);
        this.superclassButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AbstractClassSensorAssignmentDetailsPage.this.interfaceButton.equals(selectionEvent.widget) && AbstractClassSensorAssignmentDetailsPage.this.interfaceButton.getSelection()) {
                    AbstractClassSensorAssignmentDetailsPage.this.superclassButton.setSelection(false);
                } else if (AbstractClassSensorAssignmentDetailsPage.this.superclassButton.equals(selectionEvent.widget) && AbstractClassSensorAssignmentDetailsPage.this.superclassButton.getSelection()) {
                    AbstractClassSensorAssignmentDetailsPage.this.interfaceButton.setSelection(false);
                }
            }
        };
        this.interfaceButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.superclassButton.addSelectionListener((SelectionListener)selectionAdapter);
        formToolkit.createLabel(composite, "");
        this.createInfoLabel(composite, formToolkit, "Selecting Interface option all classes implementing specified interface will be instrumented, while selecting Superclass all subclass of specified class will be instrumented.");
        formToolkit.createLabel(composite, "Fully Qualified Name:");
        this.classText = formToolkit.createText(composite, "", 2048);
        this.classText.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.classSearchButton = formToolkit.createButton(composite, "", 8);
        this.classSearchButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/insp_sbook.gif"));
        this.classSearchButton.setToolTipText("Search for class");
        this.classSearchButton.setEnabled(false);
        this.createInfoLabel(composite, formToolkit, "The class/interface that should be monitored including the package name using the standard Java notation (e.g. info.novatec.inspectit.MyTestClass). The wildcard * can be used to match any length of characters.");
        InputValidatorControlDecoration inputValidatorControlDecoration = new InputValidatorControlDecoration(this.classText, this, (IInputValidator)new FqnWildcardValidator(false, false));
        inputValidatorControlDecoration.registerListener(24);
        this.addValidationControlDecoration(inputValidatorControlDecoration);
        formToolkit.createLabel(composite, "Annotation:");
        this.annotationText = formToolkit.createText(composite, "", 2048);
        this.annotationText.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.annotationSearchButton = formToolkit.createButton(composite, "", 8);
        this.annotationSearchButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/insp_sbook.gif"));
        this.annotationSearchButton.setToolTipText("Search for annotation class");
        this.annotationSearchButton.setEnabled(false);
        this.createInfoLabel(composite, formToolkit, "Sensor assignment can include the special additional option, where an annotation can be specified and used as additional instrumentation filter. If the annotation is added to the additional options part, the agent will instrument the methods/constructors based on the annotation target:\n\n1. If the annotation target is Class, then all methods from the classes that have the specified annotation will be instrumented.\n2. If the annotation target is Method, then only methods that have the specified annotation will be instrumented.");
        InputValidatorControlDecoration inputValidatorControlDecoration2 = new InputValidatorControlDecoration(this.annotationText, null, this, new FqnWildcardValidator(true, false));
        inputValidatorControlDecoration2.registerListener(24);
        this.addValidationControlDecoration(inputValidatorControlDecoration2);
        this.interfaceButton.addListener(13, this.getMarkDirtyListener());
        this.superclassButton.addListener(13, this.getMarkDirtyListener());
        this.classText.addListener(24, this.getMarkDirtyListener());
        this.annotationText.addListener(24, this.getMarkDirtyListener());
    }

    protected Listener getMarkDirtyListener() {
        return this.markDirtyListener;
    }

    protected boolean checkValid(boolean bl) {
        boolean bl2 = true;
        for (ValidationControlDecoration<?> validationControlDecoration : this.validationControlDecorations) {
            if (bl) {
                validationControlDecoration.executeValidation();
            }
            if (validationControlDecoration.isValid()) continue;
            bl2 = false;
            if (!bl) break;
        }
        this.valid = bl2;
        return bl2;
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected final void update() {
        this.updateInProgress = true;
        this.updateFromInput();
        this.checkValid(true);
        AbstractClassSensorAssignment<?> abstractClassSensorAssignment = this.getInput();
        if (abstractClassSensorAssignment != null) {
            this.masterBlockListener.sensorAssignmentUpdated(abstractClassSensorAssignment, false, this.isValid(), this.validationControlDecorations);
        }
        this.updateInProgress = false;
    }

    protected void updateFromInput() {
        this.interfaceButton.setSelection(false);
        this.superclassButton.setSelection(false);
        AbstractClassSensorAssignment<?> abstractClassSensorAssignment = this.getInput();
        if (abstractClassSensorAssignment != null) {
            this.updateTitle(abstractClassSensorAssignment.getSensorConfigClass());
            this.interfaceButton.setSelection(abstractClassSensorAssignment.isInterf());
            this.superclassButton.setSelection(abstractClassSensorAssignment.isSuperclass());
            this.classText.setText(this.getEmptyIfNull(abstractClassSensorAssignment.getClassName()));
            this.annotationText.setText(this.getEmptyIfNull(abstractClassSensorAssignment.getAnnotation()));
        } else {
            this.classText.setText("");
            this.annotationText.setText("");
        }
    }

    protected void commitToInput() {
        AbstractClassSensorAssignment<?> abstractClassSensorAssignment = this.getInput();
        if (abstractClassSensorAssignment != null) {
            abstractClassSensorAssignment.setInterf(this.interfaceButton.getSelection());
            abstractClassSensorAssignment.setSuperclass(this.superclassButton.getSelection());
            abstractClassSensorAssignment.setClassName(this.classText.getText());
            if (StringUtils.isNotBlank((String)this.annotationText.getText())) {
                abstractClassSensorAssignment.setAnnotation(this.annotationText.getText());
            } else {
                abstractClassSensorAssignment.setAnnotation(null);
            }
        }
    }

    protected String getEmptyIfNull(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            return string;
        }
        return "";
    }

    protected void createInfoLabel(Composite composite, FormToolkit formToolkit, String string) {
        Label label = formToolkit.createLabel(composite, "");
        label.setToolTipText(string);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
    }

    protected FormText createTitle(Composite composite, FormToolkit formToolkit) {
        this.title = formToolkit.createFormText(composite, false);
        this.title.setColor("header", formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.title.setFont("header", JFaceResources.getBannerFont());
        return this.title;
    }

    private void updateTitle(Class<? extends ISensorConfig> clazz) {
        String string = TextFormatter.getSensorConfigName(clazz);
        Image image = ImageFormatter.getSensorConfigImage(clazz);
        this.title.setText("<form><p> <img href=\"titleImage\"/> <span color=\"header\" font=\"header\">" + string + "</span></p></form>", true, false);
        this.title.setImage("titleImage", image);
    }

    protected void addValidationControlDecoration(ValidationControlDecoration<?> validationControlDecoration) {
        this.validationControlDecorations.add(validationControlDecoration);
    }

    @Override
    public void validationStateChanged(boolean bl, ValidationControlDecoration<?> validationControlDecoration) {
        this.checkValid(false);
    }

    protected boolean isCanEdit() {
        return this.canEdit;
    }

    protected void setEnabled(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, bl);
            } else if (!(control instanceof Label)) {
                control.setEnabled(bl);
            }
            ++n2;
        }
    }

    public final void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        if (iSelection instanceof SensorAssignmentMasterBlock.RemoveSelection) {
            boolean bl = false;
            for (Object e : ((SensorAssignmentMasterBlock.RemoveSelection)iSelection).toList()) {
                if (e != this.getInput()) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.setInput((ISelection)StructuredSelection.EMPTY);
                this.update();
            }
        } else {
            this.setInput(iSelection);
            this.update();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void commit(boolean bl) {
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
        this.classText.setFocus();
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    public void dispose() {
    }
}

