/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.minlog.Log;
import info.novatec.inspectit.storage.serializer.schema.ClassSchema;
import info.novatec.inspectit.storage.serializer.schema.ClassSchemaManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] fieldMarkers;
    private ClassSchema schema;

    public CustomCompatibleFieldSerializer(Kryo kryo, Class<?> type, ClassSchemaManager schemaManager) {
        this(kryo, type, schemaManager, false);
    }

    public CustomCompatibleFieldSerializer(Kryo kryo, Class<?> type, ClassSchemaManager schemaManager, boolean useSuperclassSchema) {
        super(kryo, type);
        this.schema = schemaManager.getSchema(type.getName());
        if (useSuperclassSchema && null == this.schema) {
            for (Class<?> superclass = type.getSuperclass(); null != superclass; superclass = superclass.getSuperclass()) {
                this.schema = schemaManager.getSchema(superclass.getName());
                if (null != this.schema) break;
            }
        }
        if (this.schema == null) {
            throw new IllegalArgumentException("Schema for the class '" + type.getName() + "' does not exists in provided schema manager.");
        }
        this.initializeCachedFields();
    }

    protected final void initializeCachedFields() {
        if (null != this.schema) {
            int i;
            FieldSerializer.CachedField[] fields = this.getFields();
            int n = fields.length;
            for (i = 0; i < n; ++i) {
                Field field = fields[i].getField();
                if (null != this.schema.getFieldMarker(field.getName())) continue;
                super.removeField(field.getName());
            }
            fields = this.getFields();
            this.fieldMarkers = new int[fields.length];
            n = fields.length;
            for (i = 0; i < n; ++i) {
                this.fieldMarkers[i] = this.schema.getFieldMarker(fields[i].getField().getName());
            }
        }
    }

    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey((Object)this)) {
            context.put((Object)this, null);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write " + fields.length + " field names."));
            }
            output.writeInt(fields.length, true);
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                output.writeInt(this.fieldMarkers[i], true);
            }
        }
        OutputChunked outputChunked = new OutputChunked((OutputStream)output, 1024);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write((Output)outputChunked, object);
            outputChunked.endChunks();
        }
    }

    public T read(Kryo kryo, Input input, Class<T> type) {
        Object object = kryo.newInstance(type);
        kryo.reference(object);
        ObjectMap context = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])context.get((Object)this);
        if (fields == null) {
            int length = input.readInt(true);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read " + length + " field names."));
            }
            int[] markers = new int[length];
            for (int i = 0; i < length; ++i) {
                markers[i] = input.readInt(true);
            }
            fields = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            block1: for (int fieldMarker : markers) {
                int nn = allFields.length;
                for (int ii = 0; ii < nn; ++ii) {
                    if (this.fieldMarkers[ii] != fieldMarker) continue;
                    fields[i] = allFields[ii];
                    continue block1;
                }
                if (!Log.TRACE) continue;
                Log.trace((String)"kryo", (String)("Ignoring obsolete field with marker: " + fieldMarker));
            }
            context.put((Object)this, (Object)fields);
        }
        InputChunked inputChunked = new InputChunked((InputStream)input, 1024);
        for (FieldSerializer.CachedField cachedField : fields) {
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)"Skip obsolete field.");
                }
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read((Input)inputChunked, object);
            inputChunked.nextChunks();
        }
        return (T)object;
    }
}

