/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.query.factory.impl;

import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.query.factory.AbstractQueryFactory;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ExceptionSensorDataQueryFactory<E extends IIndexQuery>
extends AbstractQueryFactory<E> {
    public E getUngroupedExceptionOverviewQuery(ExceptionSensorData template, int limit, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(template.getPlatformIdent());
        query.setSensorTypeIdent(template.getSensorTypeIdent());
        query.setMethodIdent(template.getMethodIdent());
        if (null != template.getThrowableType()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("throwableType", template.getThrowableType()));
        }
        ArrayList<Class> searchedClasses = new ArrayList<Class>();
        searchedClasses.add(ExceptionSensorData.class);
        searchedClasses.add(AggregatedExceptionSensorData.class);
        query.setObjectClasses(searchedClasses);
        query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("exceptionEvent", ExceptionEvent.CREATED));
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }

    public E getExceptionTreeQuery(ExceptionSensorData template) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        ArrayList<Class> searchedClasses = new ArrayList<Class>();
        searchedClasses.add(ExceptionSensorData.class);
        searchedClasses.add(AggregatedExceptionSensorData.class);
        query.setObjectClasses(searchedClasses);
        query.setPlatformIdent(template.getPlatformIdent());
        query.setMethodIdent(template.getMethodIdent());
        query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("throwableIdentityHashCode", template.getThrowableIdentityHashCode()));
        return query;
    }

    public E getDataForGroupedExceptionOverviewQuery(ExceptionSensorData template, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        ArrayList<Class> searchedClasses = new ArrayList<Class>();
        searchedClasses.add(ExceptionSensorData.class);
        searchedClasses.add(AggregatedExceptionSensorData.class);
        query.setObjectClasses(searchedClasses);
        query.setPlatformIdent(template.getPlatformIdent());
        if (null != template.getThrowableType()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("throwableType", template.getThrowableType()));
        }
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }

    public E getStackTraceMessagesForThrowableTypeQuery(ExceptionSensorData template) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        ArrayList<Class> searchedClasses = new ArrayList<Class>();
        searchedClasses.add(ExceptionSensorData.class);
        searchedClasses.add(AggregatedExceptionSensorData.class);
        query.setObjectClasses(searchedClasses);
        query.setPlatformIdent(template.getPlatformIdent());
        query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("throwableType", template.getThrowableType()));
        query.addIndexingRestriction(IndexQueryRestrictionFactory.isNotNull("stackTrace"));
        return query;
    }
}

