/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.FactoryBean;

public class ExecutorServiceFactory
implements FactoryBean<ExecutorService> {
    private String threadNamePrefix;
    private boolean daemon;
    private int executorThreads;
    private boolean isBeanSingleton;
    private boolean isScheduledExecutor;

    public ExecutorService getObject() throws Exception {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.threadNamePrefix + "-thread-%d").setDaemon(this.daemon).build();
        if (!this.isScheduledExecutor) {
            return Executors.newFixedThreadPool(this.executorThreads, threadFactory);
        }
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(this.executorThreads, threadFactory);
        scheduledExecutor.setRemoveOnCancelPolicy(true);
        return scheduledExecutor;
    }

    public Class<?> getObjectType() {
        if (!this.isScheduledExecutor) {
            return ExecutorService.class;
        }
        return ScheduledExecutorService.class;
    }

    public boolean isSingleton() {
        return this.isBeanSingleton;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setExecutorThreads(int executorThreads) {
        this.executorThreads = executorThreads;
    }

    public void setBeanSingleton(boolean isBeanSingleton) {
        this.isBeanSingleton = isBeanSingleton;
    }

    public void setScheduledExecutor(boolean isScheduledExecutor) {
        this.isScheduledExecutor = isScheduledExecutor;
    }
}

