/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.label;

import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.text.DateFormat;
import java.util.Date;
import javax.persistence.Entity;
import javax.validation.constraints.NotNull;

@Entity
public class DateStorageLabel
extends AbstractStorageLabel<Date> {
    private static final long serialVersionUID = -170345155369176042L;
    @NotNull
    private Date dateValue;

    public DateStorageLabel() {
    }

    public DateStorageLabel(Date dateValue, AbstractStorageLabelType<Date> storageLabelType) {
        super(storageLabelType);
        this.dateValue = dateValue;
    }

    @Override
    public Date getValue() {
        return this.dateValue;
    }

    @Override
    public void setValue(Date value) {
        this.dateValue = value;
    }

    @Override
    public String getFormatedValue() {
        return DateFormat.getDateInstance().format(this.dateValue);
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dateValue == null ? 0 : this.dateValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateStorageLabel other = (DateStorageLabel)obj;
        return !(this.dateValue == null ? other.dateValue != null : !this.dateValue.equals(other.dateValue));
    }

    @Override
    public int compareTo(AbstractStorageLabel<?> other) {
        int typeCompare = this.storageLabelType.compareTo(other.getStorageLabelType());
        if (0 != typeCompare) {
            return typeCompare;
        }
        if (!DateStorageLabel.class.isAssignableFrom(other.getClass())) {
            return super.compareTo(other);
        }
        DateStorageLabel otherLabel = (DateStorageLabel)other;
        return this.dateValue.compareTo(otherLabel.dateValue);
    }
}

