/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.AbstractBranch;
import info.novatec.inspectit.indexing.ITreeComponent;
import info.novatec.inspectit.indexing.storage.IStorageBranchIndexer;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;

public class StorageBranch<E extends DefaultData>
extends AbstractBranch<IStorageDescriptor, E>
implements IStorageTreeComponent<E> {
    private IStorageBranchIndexer<E> storageBranchIndexer;

    public StorageBranch() {
        super(null);
    }

    public StorageBranch(IStorageBranchIndexer<E> storageBranchIndexer) {
        super(storageBranchIndexer);
        this.storageBranchIndexer = storageBranchIndexer;
    }

    @Override
    protected ITreeComponent<IStorageDescriptor, E> getNextTreeComponent(E element) {
        return this.storageBranchIndexer.getNextTreeComponent(element);
    }

    @Override
    public void preWriteFinalization() {
        for (ITreeComponent storageTreeComponent : this.getComponentMap().values()) {
            if (!(storageTreeComponent instanceof IStorageTreeComponent)) continue;
            ((IStorageTreeComponent)storageTreeComponent).preWriteFinalization();
        }
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        long size = super.getComponentSize(objectSizes);
        return objectSizes.alignTo8Bytes(size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0));
    }

    IStorageBranchIndexer<E> getStorageBranchIndexer() {
        return this.storageBranchIndexer;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.storageBranchIndexer == null ? 0 : this.storageBranchIndexer.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageBranch other = (StorageBranch)obj;
        return !(this.storageBranchIndexer == null ? other.storageBranchIndexer != null : !this.storageBranchIndexer.equals(other.storageBranchIndexer));
    }
}

