/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.service.ServiceExporterType;
import info.novatec.inspectit.cmr.service.ServiceInterface;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.RecordingData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.management.AbstractLabelManagementAction;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@ServiceInterface(exporter=ServiceExporterType.HTTP)
public interface IStorageService {
    public StorageData createAndOpenStorage(StorageData var1) throws BusinessException;

    public void closeStorage(StorageData var1) throws BusinessException;

    public void deleteStorage(StorageData var1) throws BusinessException;

    public boolean isStorageOpen(StorageData var1);

    public List<StorageData> getOpenedStorages();

    public List<StorageData> getExistingStorages();

    public List<StorageData> getReadableStorages();

    public RecordingState getRecordingState();

    public StorageData startOrScheduleRecording(StorageData var1, RecordingProperties var2) throws BusinessException;

    public void stopRecording() throws BusinessException;

    public RecordingData getRecordingData();

    public void writeToStorage(StorageData var1, Collection<DefaultData> var2, Collection<AbstractDataProcessor> var3, boolean var4) throws BusinessException;

    public StorageData copyBufferToStorage(StorageData var1, List<Long> var2, Collection<AbstractDataProcessor> var3, boolean var4) throws BusinessException;

    public StorageData copyDataToStorage(StorageData var1, Collection<Long> var2, long var3, Collection<AbstractDataProcessor> var5, boolean var6) throws BusinessException;

    public Map<String, Long> getIndexFilesLocations(StorageData var1) throws BusinessException;

    public Map<String, Long> getDataFilesLocations(StorageData var1) throws BusinessException;

    public Map<String, Long> getCachedDataFilesLocations(StorageData var1) throws BusinessException;

    public Map<String, Long> getAgentFilesLocations(StorageData var1) throws BusinessException;

    public StorageData addLabelToStorage(StorageData var1, AbstractStorageLabel<?> var2, boolean var3) throws BusinessException;

    public StorageData addLabelsToStorage(StorageData var1, Collection<AbstractStorageLabel<?>> var2, boolean var3) throws BusinessException;

    public StorageData removeLabelFromStorage(StorageData var1, AbstractStorageLabel<?> var2) throws BusinessException;

    public StorageData removeLabelsFromStorage(StorageData var1, List<AbstractStorageLabel<?>> var2) throws BusinessException;

    public Collection<AbstractStorageLabel<?>> getAllLabelsInStorages();

    public List<AbstractStorageLabel<?>> getAllLabels();

    public <E> List<AbstractStorageLabel<E>> getLabelSuggestions(AbstractStorageLabelType<E> var1);

    public void saveLabelToCmr(AbstractStorageLabel<?> var1);

    public void saveLabelsToCmr(Collection<AbstractStorageLabel<?>> var1);

    public void removeLabelFromCmr(AbstractStorageLabel<?> var1, boolean var2) throws BusinessException;

    public void removeLabelsFromCmr(Collection<AbstractStorageLabel<?>> var1, boolean var2) throws BusinessException;

    public void saveLabelType(AbstractStorageLabelType<?> var1);

    public void removeLabelType(AbstractStorageLabelType<?> var1) throws BusinessException;

    public <E extends AbstractStorageLabelType<?>> List<E> getLabelTypes(Class<E> var1);

    public List<AbstractStorageLabelType<?>> getAllLabelTypes();

    public void executeLabelManagementActions(Collection<AbstractLabelManagementAction> var1) throws BusinessException;

    public void updateStorageData(StorageData var1) throws BusinessException;

    public long getStorageQueuedWriteTaskCount(StorageData var1);

    public void unpackUploadedStorage(IStorageData var1) throws BusinessException;

    public void createStorageFromUploadedDir(IStorageData var1) throws BusinessException;

    public void cacheStorageData(StorageData var1, Collection<? extends DefaultData> var2, int var3) throws BusinessException;

    public String getCachedStorageDataFileLocation(StorageData var1, int var2) throws BusinessException;
}

