/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration;

import info.novatec.inspectit.cmr.property.configuration.AbstractProperty;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="section")
@XmlSeeAlso(value={AbstractProperty.class})
public class PropertySection {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlElementWrapper(name="properties")
    @XmlElementRef
    private Set<AbstractProperty> properties = new LinkedHashSet<AbstractProperty>();

    public PropertySection() {
    }

    public PropertySection(String name) {
        this.name = name;
    }

    public boolean hasAdvancedProperties() {
        if (CollectionUtils.isNotEmpty(this.properties)) {
            for (AbstractProperty property : this.properties) {
                if (!property.isAdvanced()) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Set<AbstractProperty> getProperties() {
        return this.properties;
    }

    public void addProperty(AbstractProperty property) {
        this.properties.add(property);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertySection other = (PropertySection)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

