/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio;

import info.novatec.inspectit.cmr.property.spring.PropertyUpdate;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.nio.bytebuffer.ByteBufferFactory;
import info.novatec.inspectit.util.UnderlyingSystemInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ByteBufferProvider
extends GenericObjectPool<ByteBuffer>
implements InitializingBean {
    @Log
    Logger log;
    public static final int DEFAULT_BUFFER_CAPACITY = 0x100000;
    private static final long MAX_WAIT = 60000L;
    @Value(value="${storage.bufferSize}")
    private int bufferSize = 0x100000;
    private ByteBufferFactory poolFactory;
    @Value(value="${storage.bufferPoolMinCapacity}")
    private long poolMinCapacity;
    @Value(value="${storage.bufferPoolMaxCapacity}")
    private long poolMaxCapacity;
    @Value(value="${storage.bufferPoolMinDirectMemoryOccupancy}")
    private float bufferPoolMinDirectMemoryOccupancy;
    @Value(value="${storage.bufferPoolMaxDirectMemoryOccupancy}")
    private float bufferPoolMaxDirectMemoryOccupancy;

    public ByteBufferProvider() {
        this(new ByteBufferFactory(0x100000));
    }

    protected ByteBufferProvider(ByteBufferFactory poolFactory) {
        this(poolFactory, 60000L);
    }

    ByteBufferProvider(ByteBufferFactory poolFactory, long maxWait) {
        super((PoolableObjectFactory)poolFactory);
        this.poolFactory = poolFactory;
        this.setMaxWait(maxWait);
        this.setWhenExhaustedAction((byte)1);
    }

    public ByteBuffer acquireByteBuffer() throws IOException {
        try {
            return (ByteBuffer)super.borrowObject();
        }
        catch (Exception e) {
            IOException ioException = new IOException("Byte buffer pool can not borrow a valid byte buffer.");
            ioException.initCause(e);
            throw ioException;
        }
    }

    public void releaseByteBuffer(ByteBuffer byteBuffer) {
        try {
            super.returnObject((Object)byteBuffer);
        }
        catch (Exception e) {
            this.log.error("Byte buffer can not be returned to the byte buffer pool.", (Throwable)e);
            return;
        }
    }

    public int getBufferPoolSize() {
        return super.getNumIdle();
    }

    public long getCreatedCapacity() {
        return (super.getNumActive() + super.getNumIdle()) * this.bufferSize;
    }

    public long getAvailableCapacity() {
        return super.getNumIdle() * this.bufferSize;
    }

    public void setPoolMaxCapacity(long poolMaxCapacity) {
        this.poolMaxCapacity = poolMaxCapacity;
    }

    public void setPoolMinCapacity(long poolMinCapacity) {
        this.poolMinCapacity = poolMinCapacity;
    }

    public void setBufferPoolMinDirectMemoryOccupancy(float bufferPoolMinDirectMemoryOccupancy) {
        this.bufferPoolMinDirectMemoryOccupancy = bufferPoolMinDirectMemoryOccupancy;
    }

    public void setBufferPoolMaxDirectMemoryOccupancy(float bufferPoolMaxDirectMemoryOccupancy) {
        this.bufferPoolMaxDirectMemoryOccupancy = bufferPoolMaxDirectMemoryOccupancy;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void init() {
        if (this.bufferPoolMinDirectMemoryOccupancy > this.bufferPoolMaxDirectMemoryOccupancy) {
            throw new BeanInitializationException("Settings for the byte buffer pool are not correct. bufferPoolMinDirectMemoryOccupancy (" + this.bufferPoolMaxDirectMemoryOccupancy + ") is greater than bufferPoolMaxDirectMemoryOccupancy (" + this.bufferPoolMinDirectMemoryOccupancy + ")");
        }
        if (this.poolMinCapacity > this.poolMaxCapacity) {
            throw new BeanInitializationException("Settings for the byte buffer pool are not correct. poolMinCapacity (" + this.poolMinCapacity + ") is greater than poolMaxCapacity (" + this.poolMaxCapacity + ")");
        }
        this.updatePoolProperties();
    }

    @PropertyUpdate(properties={"storage.bufferSize", "storage.bufferPoolMinCapacity", "storage.bufferPoolMaxCapacity", "storage.bufferPoolMinDirectMemoryOccupancy", "storage.bufferPoolMaxDirectMemoryOccupancy"})
    protected void updatePoolProperties() {
        long maxDirectMemory;
        block5: {
            maxDirectMemory = 0x4000000L;
            try {
                if (UnderlyingSystemInfo.JVM_PROVIDER.equals((Object)UnderlyingSystemInfo.JvmProvider.SUN) || UnderlyingSystemInfo.JVM_PROVIDER.equals((Object)UnderlyingSystemInfo.JvmProvider.ORACLE)) {
                    Class<?> vmClazz = Class.forName("sun.misc.VM");
                    Method directMemoryMethod = vmClazz.getMethod("maxDirectMemory", new Class[0]);
                    directMemoryMethod.setAccessible(true);
                    maxDirectMemory = (Long)directMemoryMethod.invoke(null, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("Exception occurred trying to use the class sun.misc.VM via reflection", (Throwable)e);
            }
        }
        if (this.poolMinCapacity > (long)((float)maxDirectMemory * this.bufferPoolMinDirectMemoryOccupancy)) {
            this.poolMinCapacity = (long)((float)maxDirectMemory * this.bufferPoolMinDirectMemoryOccupancy);
        }
        if (this.poolMaxCapacity > (long)((float)maxDirectMemory * this.bufferPoolMaxDirectMemoryOccupancy)) {
            this.poolMaxCapacity = (long)((float)maxDirectMemory * this.bufferPoolMaxDirectMemoryOccupancy);
        }
        this.poolFactory.setBufferCapacity(this.bufferSize);
        int maxIdle = (int)(this.poolMinCapacity / (long)this.bufferSize);
        int maxActive = (int)(this.poolMaxCapacity / (long)this.bufferSize);
        super.setMaxIdle(maxIdle);
        super.setMaxActive(maxActive);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("poolMinCapacity", this.poolMinCapacity);
        toStringBuilder.append("poolMaxCapacity", this.poolMaxCapacity);
        return toStringBuilder.toString();
    }
}

