/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class HttpTimerDataHelper {
    private HttpTimerDataHelper() {
    }

    public static String getTransformedUri(HttpTimerData httpTimerData, String regEx, String regExTemplate) throws IllegalArgumentException {
        if (!httpTimerData.getHttpInfo().isUriDefined()) {
            throw new IllegalArgumentException("URI is not defined for the given HttpTimerData.");
        }
        if (null == regEx) {
            throw new IllegalArgumentException("Regular expression to use can not be null.");
        }
        try {
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(httpTimerData.getHttpInfo().getUri());
            String result = "";
            if (null != regExTemplate) {
                result = regExTemplate;
            }
            if (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (null != regExTemplate) {
                        String matched = matcher.group(i);
                        if (null == matched) continue;
                        result = result.replace("$" + i + "$", matcher.group(i));
                        continue;
                    }
                    result = result + matcher.group(i);
                }
                if (!ObjectUtils.equals(result, regExTemplate)) {
                    return result;
                }
            }
            return "Regular Expression " + regEx + " does not match URI";
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Provided Regular expression is not correct.", patternSyntaxException);
        }
    }
}

