/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ClassLoadingInformationData
extends SystemSensorData
implements IAggregatedData<ClassLoadingInformationData> {
    private static final long serialVersionUID = 3670151927025437963L;
    private int count = 0;
    private int minLoadedClassCount = Integer.MAX_VALUE;
    private int maxLoadedClassCount = 0;
    private int totalLoadedClassCount = 0;
    private long minTotalLoadedClassCount = Long.MAX_VALUE;
    private long maxTotalLoadedClassCount = 0L;
    private long totalTotalLoadedClassCount = 0L;
    private long minUnloadedClassCount = Long.MAX_VALUE;
    private long maxUnloadedClassCount = 0L;
    private long totalUnloadedClassCount = 0L;

    public ClassLoadingInformationData() {
    }

    public ClassLoadingInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void addLoadedClassCount(int loadedClassCount) {
        this.totalLoadedClassCount += loadedClassCount;
    }

    public int getMinLoadedClassCount() {
        return this.minLoadedClassCount;
    }

    public void setMinLoadedClassCount(int minLoadedClassCount) {
        this.minLoadedClassCount = minLoadedClassCount;
    }

    public int getMaxLoadedClassCount() {
        return this.maxLoadedClassCount;
    }

    public void setMaxLoadedClassCount(int maxLoadedClassCount) {
        this.maxLoadedClassCount = maxLoadedClassCount;
    }

    public int getTotalLoadedClassCount() {
        return this.totalLoadedClassCount;
    }

    public void setTotalLoadedClassCount(int totalLoadedClassCount) {
        this.totalLoadedClassCount = totalLoadedClassCount;
    }

    public void addTotalLoadedClassCount(long totalLoadedClassCount) {
        this.totalTotalLoadedClassCount += totalLoadedClassCount;
    }

    public long getMinTotalLoadedClassCount() {
        return this.minTotalLoadedClassCount;
    }

    public void setMinTotalLoadedClassCount(long minTotalLoadedClassCount) {
        this.minTotalLoadedClassCount = minTotalLoadedClassCount;
    }

    public long getMaxTotalLoadedClassCount() {
        return this.maxTotalLoadedClassCount;
    }

    public void setMaxTotalLoadedClassCount(long maxTotalLoadedClassCount) {
        this.maxTotalLoadedClassCount = maxTotalLoadedClassCount;
    }

    public long getTotalTotalLoadedClassCount() {
        return this.totalTotalLoadedClassCount;
    }

    public void setTotalTotalLoadedClassCount(long totalTotalLoadedClassCount) {
        this.totalTotalLoadedClassCount = totalTotalLoadedClassCount;
    }

    public void addUnloadedClassCount(long unloadedClassCount) {
        this.totalUnloadedClassCount += unloadedClassCount;
    }

    public long getMinUnloadedClassCount() {
        return this.minUnloadedClassCount;
    }

    public void setMinUnloadedClassCount(long minUnloadedClassCount) {
        this.minUnloadedClassCount = minUnloadedClassCount;
    }

    public long getMaxUnloadedClassCount() {
        return this.maxUnloadedClassCount;
    }

    public void setMaxUnloadedClassCount(long maxUnloadedClassCount) {
        this.maxUnloadedClassCount = maxUnloadedClassCount;
    }

    public long getTotalUnloadedClassCount() {
        return this.totalUnloadedClassCount;
    }

    public void setTotalUnloadedClassCount(long totalUnloadedClassCount) {
        this.totalUnloadedClassCount = totalUnloadedClassCount;
    }

    @Override
    public void aggregate(ClassLoadingInformationData other) {
        this.count += other.count;
        this.minLoadedClassCount = Math.min(this.minLoadedClassCount, other.minLoadedClassCount);
        this.maxLoadedClassCount = Math.max(this.maxLoadedClassCount, other.maxLoadedClassCount);
        this.totalLoadedClassCount += other.totalLoadedClassCount;
        this.minTotalLoadedClassCount = Math.min(this.minTotalLoadedClassCount, other.minTotalLoadedClassCount);
        this.maxTotalLoadedClassCount = Math.max(this.maxTotalLoadedClassCount, other.maxTotalLoadedClassCount);
        this.totalTotalLoadedClassCount += other.totalTotalLoadedClassCount;
        this.minUnloadedClassCount = Math.min(this.minUnloadedClassCount, other.minUnloadedClassCount);
        this.maxUnloadedClassCount = Math.max(this.maxUnloadedClassCount, other.maxUnloadedClassCount);
        this.totalUnloadedClassCount += other.maxUnloadedClassCount;
    }

    @Override
    public ClassLoadingInformationData getData() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + this.maxLoadedClassCount;
        result = 31 * result + (int)(this.maxTotalLoadedClassCount ^ this.maxTotalLoadedClassCount >>> 32);
        result = 31 * result + (int)(this.maxUnloadedClassCount ^ this.maxUnloadedClassCount >>> 32);
        result = 31 * result + this.minLoadedClassCount;
        result = 31 * result + (int)(this.minTotalLoadedClassCount ^ this.minTotalLoadedClassCount >>> 32);
        result = 31 * result + (int)(this.minUnloadedClassCount ^ this.minUnloadedClassCount >>> 32);
        result = 31 * result + this.totalLoadedClassCount;
        result = 31 * result + (int)(this.totalTotalLoadedClassCount ^ this.totalTotalLoadedClassCount >>> 32);
        result = 31 * result + (int)(this.totalUnloadedClassCount ^ this.totalUnloadedClassCount >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassLoadingInformationData other = (ClassLoadingInformationData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.maxLoadedClassCount != other.maxLoadedClassCount) {
            return false;
        }
        if (this.maxTotalLoadedClassCount != other.maxTotalLoadedClassCount) {
            return false;
        }
        if (this.maxUnloadedClassCount != other.maxUnloadedClassCount) {
            return false;
        }
        if (this.minLoadedClassCount != other.minLoadedClassCount) {
            return false;
        }
        if (this.minTotalLoadedClassCount != other.minTotalLoadedClassCount) {
            return false;
        }
        if (this.minUnloadedClassCount != other.minUnloadedClassCount) {
            return false;
        }
        if (this.totalLoadedClassCount != other.totalLoadedClassCount) {
            return false;
        }
        if (this.totalTotalLoadedClassCount != other.totalTotalLoadedClassCount) {
            return false;
        }
        return this.totalUnloadedClassCount == other.totalUnloadedClassCount;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 0, 4, 0, 6, 0);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

