/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.ExportStorageWizardPage;
import info.novatec.inspectit.rcp.wizard.page.StorageCompressionWizardPage;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class ExportStorageWizard
extends Wizard
implements INewWizard {
    private IStorageData storageData;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private ExportStorageWizardPage exportStorageWizardPage;
    private StorageCompressionWizardPage storageCompressionWizardPage;

    protected ExportStorageWizard() {
        this.setWindowTitle("Export Storage");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/import_wiz.png"));
    }

    public ExportStorageWizard(LocalStorageData localStorageData) {
        this();
        this.storageData = localStorageData;
    }

    public ExportStorageWizard(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        this();
        this.storageData = storageData;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.exportStorageWizardPage = new ExportStorageWizardPage(this.storageData);
        this.addPage((IWizardPage)this.exportStorageWizardPage);
        if (this.storageData instanceof StorageData) {
            StorageData storageData = (StorageData)this.storageData;
            if (!InspectIT.getDefault().getInspectITStorageManager().isFullyDownloaded(storageData)) {
                String string = "Export Storage";
                String string2 = "Options for exporting the storage '" + this.storageData.getName() + "' (size: " + NumberFormatter.formatBytesToMBytes(this.storageData.getDiskSize()) + ")";
                this.storageCompressionWizardPage = new StorageCompressionWizardPage(string, string2);
                this.addPage((IWizardPage)this.storageCompressionWizardPage);
            }
        }
    }

    public boolean performFinish() {
        final InspectITStorageManager inspectITStorageManager = InspectIT.getDefault().getInspectITStorageManager();
        final String string = this.exportStorageWizardPage.getFileName();
        LocalStorageData localStorageData = null;
        if (this.storageData instanceof LocalStorageData) {
            localStorageData = (LocalStorageData)this.storageData;
        } else if (this.storageData instanceof StorageData) {
            localStorageData = inspectITStorageManager.getLocalDataForStorage((StorageData)this.storageData);
        }
        if (localStorageData != null && localStorageData.isFullyDownloaded()) {
            final LocalStorageData localStorageData2 = localStorageData;
            Job job = new Job("Export Storage"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask("Exporting data..", -1);
                    try {
                        inspectITStorageManager.zipStorageData(localStorageData2, string);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
                                if (iViewPart instanceof StorageManagerView) {
                                    ((StorageManagerView)iViewPart).refreshWithoutCmrCall();
                                }
                                InspectIT.getDefault().createInfoDialog("The storage was exported successfully.", -1);
                            }
                        });
                    }
                    catch (Exception exception) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred trying to export storage.", (Throwable)exception);
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/export.gif"));
            job.schedule();
        } else if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            final boolean bl = this.storageCompressionWizardPage.isCompressBefore();
            Job job = new Job("Download And Export Storage"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
                    try {
                        inspectITStorageManager.zipStorageData((StorageData)ExportStorageWizard.this.storageData, ExportStorageWizard.this.cmrRepositoryDefinition, string, bl, subMonitor);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                InspectIT.getDefault().createInfoDialog("The storage was downloaded and exported successfully.", -1);
                            }
                        });
                    }
                    catch (BusinessException | SerializationException | IOException throwable) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred trying to export storage.", throwable);
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/export.gif"));
            job.schedule();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InspectIT.getDefault().createInfoDialog("The storage could not be downloaded, the CMR Repository is offline. Export will be aborted.", -1);
                }
            });
        }
        return true;
    }
}

