/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.page.DefineCmrWizardPage;
import info.novatec.inspectit.rcp.wizard.page.PreviewCmrDataWizardPage;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditCmrRepositoryWizard
extends Wizard
implements INewWizard {
    private DefineCmrWizardPage defineCmrWizardPage;
    private PreviewCmrDataWizardPage previewCmrDataWizardPage;
    private CmrRepositoryDefinition cmrRepositoryDefinition;

    public EditCmrRepositoryWizard(CmrRepositoryDefinition cmrRepositoryDefinition) {
        Assert.isNotNull((Object)cmrRepositoryDefinition);
        this.setWindowTitle("Edit Central Management Repository (CMR)");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/edit_wiz.png"));
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.defineCmrWizardPage = new DefineCmrWizardPage("Edit CMR Repository", this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.defineCmrWizardPage);
        this.previewCmrDataWizardPage = new PreviewCmrDataWizardPage();
        this.addPage((IWizardPage)this.previewCmrDataWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (Objects.equals(iWizardPage, (Object)this.defineCmrWizardPage)) {
            this.previewCmrDataWizardPage.cancel();
            this.previewCmrDataWizardPage.update(this.defineCmrWizardPage.getCmrRepositoryDefinition());
        }
        return super.getNextPage(iWizardPage);
    }

    public boolean performFinish() {
        CmrRepositoryDefinition cmrRepositoryDefinition = this.defineCmrWizardPage.getCmrRepositoryDefinition();
        if (Objects.equals(cmrRepositoryDefinition, this.cmrRepositoryDefinition)) {
            this.cmrRepositoryDefinition.setName(cmrRepositoryDefinition.getName());
            this.cmrRepositoryDefinition.setDescription(cmrRepositoryDefinition.getDescription());
            InspectIT.getDefault().getCmrRepositoryManager().updateCmrRepositoryDefinitionData(this.cmrRepositoryDefinition);
        } else {
            InspectIT.getDefault().getCmrRepositoryManager().removeCmrRepositoryDefinition(this.cmrRepositoryDefinition);
            InspectIT.getDefault().getCmrRepositoryManager().addCmrRepositoryDefinition(cmrRepositoryDefinition);
        }
        return true;
    }
}

