/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IIdsAwareAggregatedData;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.AggregatedHttpTimerData;
import info.novatec.inspectit.communication.data.AggregatedSqlStatementData;
import info.novatec.inspectit.communication.data.AggregatedTimerData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.AddStorageLabelWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineDataProcessorsWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineNewStorageWizzardPage;
import info.novatec.inspectit.rcp.wizard.page.NewOrExistsingStorageWizardPage;
import info.novatec.inspectit.rcp.wizard.page.SelectExistingStorageWizardPage;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CopyDataToStorageWizard
extends Wizard
implements INewWizard {
    private Collection<DefaultData> copyDataList;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private NewOrExistsingStorageWizardPage newOrExistsingStorageWizardPage;
    private DefineNewStorageWizzardPage defineNewStorageWizzardPage;
    private SelectExistingStorageWizardPage selectExistingStorageWizardPage;
    private DefineDataProcessorsWizardPage defineDataProcessorsWizardPage;
    private AddStorageLabelWizardPage addLabelWizardPage;

    public CopyDataToStorageWizard(CmrRepositoryDefinition cmrRepositoryDefinition, Collection<DefaultData> collection) {
        this.copyDataList = collection;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.setWindowTitle("Save Data to Storage Wizard");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/storage_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        int n = 0;
        for (DefaultData defaultData : this.copyDataList) {
            Class<?> clazz = defaultData.getClass();
            if (HttpTimerData.class.equals(clazz) || AggregatedHttpTimerData.class.equals(clazz)) {
                n |= 0x40;
                continue;
            }
            if (SqlStatementData.class.equals(clazz) || AggregatedSqlStatementData.class.equals(clazz)) {
                n |= 0x20;
                continue;
            }
            if (ExceptionSensorData.class.equals(clazz) || AggregatedExceptionSensorData.class.equals(clazz)) {
                n |= 0x80;
                continue;
            }
            if (TimerData.class.equals(clazz) || AggregatedTimerData.class.equals(clazz)) {
                n |= 0x10;
                continue;
            }
            if (!InvocationSequenceData.class.equals(clazz)) continue;
            n |= 0xC;
        }
        this.newOrExistsingStorageWizardPage = new NewOrExistsingStorageWizardPage();
        this.addPage((IWizardPage)this.newOrExistsingStorageWizardPage);
        this.defineNewStorageWizzardPage = new DefineNewStorageWizzardPage(this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.defineNewStorageWizzardPage);
        this.selectExistingStorageWizardPage = new SelectExistingStorageWizardPage(this.cmrRepositoryDefinition, false);
        this.addPage((IWizardPage)this.selectExistingStorageWizardPage);
        this.defineDataProcessorsWizardPage = new DefineDataProcessorsWizardPage(n);
        this.addPage((IWizardPage)this.defineDataProcessorsWizardPage);
        this.addLabelWizardPage = new AddStorageLabelWizardPage(this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.addLabelWizardPage);
    }

    public boolean performFinish() {
        boolean bl;
        StorageData storageData;
        if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
            storageData = this.defineNewStorageWizzardPage.getStorageData();
            bl = this.defineNewStorageWizzardPage.isAutoFinalize();
        } else {
            storageData = this.selectExistingStorageWizardPage.getSelectedStorageData();
            bl = this.selectExistingStorageWizardPage.isAutoFinalize();
        }
        if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            final List<AbstractDataProcessor> list = this.defineDataProcessorsWizardPage.getProcessorList();
            final HashSet<Long> hashSet = new HashSet<Long>();
            HashSet<Long> hashSet2 = new HashSet<Long>();
            for (DefaultData defaultData : this.copyDataList) {
                if (defaultData instanceof IIdsAwareAggregatedData) {
                    hashSet.addAll(((IIdsAwareAggregatedData)defaultData).getAggregatedIds());
                } else if (0L != defaultData.getId()) {
                    hashSet.add(defaultData.getId());
                }
                if (defaultData instanceof InvocationAwareData) {
                    hashSet.addAll(((InvocationAwareData)defaultData).getInvocationParentsIdSet());
                }
                hashSet2.add(defaultData.getPlatformIdent());
            }
            final long l = hashSet2.size() == 1 ? (Long)hashSet2.iterator().next() : 0L;
            Job job = new Job("Copy Data to Buffer"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        StorageData storageData2 = CopyDataToStorageWizard.this.cmrRepositoryDefinition.getStorageService().copyDataToStorage(storageData, (Collection)hashSet, l, list, bl);
                        List<AbstractStorageLabel<?>> list2 = CopyDataToStorageWizard.this.addLabelWizardPage.getLabelsToAdd();
                        if (!list2.isEmpty()) {
                            CopyDataToStorageWizard.this.cmrRepositoryDefinition.getStorageService().addLabelsToStorage(storageData2, list2, true);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                                if (iViewPart instanceof StorageManagerView) {
                                    ((StorageManagerView)iViewPart).refresh(CopyDataToStorageWizard.this.cmrRepositoryDefinition);
                                }
                            }
                        });
                    }
                    catch (BusinessException businessException) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Copy data to buffer failed.", (Throwable)businessException);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.newOrExistsingStorageWizardPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectExistingStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage))) {
            this.addLabelWizardPage.setStorageData(this.defineNewStorageWizzardPage.getStorageData());
            return this.defineDataProcessorsWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectExistingStorageWizardPage))) {
            this.addLabelWizardPage.setStorageData(this.selectExistingStorageWizardPage.getSelectedStorageData());
            return this.defineDataProcessorsWizardPage;
        }
        return super.getNextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage)) || ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectExistingStorageWizardPage))) {
            return this.newOrExistsingStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineDataProcessorsWizardPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectExistingStorageWizardPage;
        }
        return super.getPreviousPage(iWizardPage);
    }

    public boolean canFinish() {
        if (!this.newOrExistsingStorageWizardPage.isPageComplete()) {
            return false;
        }
        if (this.newOrExistsingStorageWizardPage.useNewStorage() && !this.defineNewStorageWizzardPage.isPageComplete()) {
            return false;
        }
        if (!this.newOrExistsingStorageWizardPage.useNewStorage() && !this.selectExistingStorageWizardPage.isPageComplete()) {
            return false;
        }
        return this.defineDataProcessorsWizardPage.isPageComplete();
    }
}

