/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.AddStorageLabelWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineDataProcessorsWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineNewStorageWizzardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineTimelineWizardPage;
import info.novatec.inspectit.rcp.wizard.page.NewOrExistsingStorageWizardPage;
import info.novatec.inspectit.rcp.wizard.page.SelectAgentsWizardPage;
import info.novatec.inspectit.rcp.wizard.page.SelectExistingStorageWizardPage;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.impl.TimeFrameDataProcessor;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class CopyBufferToStorageWizard
extends Wizard
implements INewWizard {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private Collection<PlatformIdent> autoSelectedAgents;
    private NewOrExistsingStorageWizardPage newOrExistsingStorageWizardPage;
    private DefineNewStorageWizzardPage defineNewStorageWizzardPage;
    private SelectExistingStorageWizardPage selectExistingStorageWizardPage;
    private SelectAgentsWizardPage selectAgentsPage;
    private DefineDataProcessorsWizardPage defineProcessorsPage;
    private DefineTimelineWizardPage timelineWizardPage;
    private AddStorageLabelWizardPage addLabelWizardPage;

    public CopyBufferToStorageWizard(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this(cmrRepositoryDefinition, Collections.emptyList());
    }

    public CopyBufferToStorageWizard(CmrRepositoryDefinition cmrRepositoryDefinition, Collection<PlatformIdent> collection) {
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.autoSelectedAgents = collection;
        this.setWindowTitle("Copy Buffer to Storage Wizard");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/storage_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.newOrExistsingStorageWizardPage = new NewOrExistsingStorageWizardPage();
        this.addPage((IWizardPage)this.newOrExistsingStorageWizardPage);
        this.defineNewStorageWizzardPage = new DefineNewStorageWizzardPage(this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.defineNewStorageWizzardPage);
        this.selectExistingStorageWizardPage = new SelectExistingStorageWizardPage(this.cmrRepositoryDefinition, false);
        this.addPage((IWizardPage)this.selectExistingStorageWizardPage);
        this.selectAgentsPage = new SelectAgentsWizardPage("Select Agent(s) to be copied", this.autoSelectedAgents);
        this.addPage((IWizardPage)this.selectAgentsPage);
        this.defineProcessorsPage = new DefineDataProcessorsWizardPage(3);
        this.addPage((IWizardPage)this.defineProcessorsPage);
        this.timelineWizardPage = new DefineTimelineWizardPage("Limit Data", "Optionally select set of data to be copied by defining time frame", 6);
        this.addPage((IWizardPage)this.timelineWizardPage);
        this.addLabelWizardPage = new AddStorageLabelWizardPage(this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.addLabelWizardPage);
    }

    public boolean performFinish() {
        TimeFrameDataProcessor timeFrameDataProcessor;
        Object object;
        List<Long> list;
        boolean bl;
        CmrRepositoryDefinition cmrRepositoryDefinition;
        StorageData storageData;
        if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
            storageData = this.defineNewStorageWizzardPage.getStorageData();
            cmrRepositoryDefinition = this.defineNewStorageWizzardPage.getSelectedRepository();
            bl = this.defineNewStorageWizzardPage.isAutoFinalize();
        } else {
            storageData = this.selectExistingStorageWizardPage.getSelectedStorageData();
            cmrRepositoryDefinition = this.selectExistingStorageWizardPage.getSelectedRepository();
            bl = this.selectExistingStorageWizardPage.isAutoFinalize();
        }
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            list = this.selectAgentsPage.getSelectedAgents();
            object = this.defineProcessorsPage.getProcessorList();
            if (this.timelineWizardPage.isTimerframeUsed()) {
                timeFrameDataProcessor = this.timelineWizardPage.getTimeFrameDataProcessor((Collection<AbstractDataProcessor>)object);
                object = new ArrayList(1);
                object.add(timeFrameDataProcessor);
            }
        } else {
            InspectIT.getDefault().createErrorDialog("Copy of the buffer data to storage failed. Selected CMR repository is currently not available.", -1);
            return false;
        }
        timeFrameDataProcessor = object;
        Job job = new Job("Copy Buffer to Storage", (List)timeFrameDataProcessor, bl){
            private final /* synthetic */ List val$finalProcessors;
            private final /* synthetic */ boolean val$autoFinalize;
            {
                this.val$finalProcessors = list2;
                this.val$autoFinalize = bl;
                super(string);
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    iProgressMonitor.beginTask("Copying the content of repository buffer to storage.", -1);
                    StorageData storageData2 = cmrRepositoryDefinition.getStorageService().copyBufferToStorage(storageData, list, (Collection)this.val$finalProcessors, this.val$autoFinalize);
                    List<AbstractStorageLabel<?>> list2 = CopyBufferToStorageWizard.this.addLabelWizardPage.getLabelsToAdd();
                    if (!list2.isEmpty()) {
                        cmrRepositoryDefinition.getStorageService().addLabelsToStorage(storageData2, list2, true);
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                            if (iViewPart instanceof StorageManagerView) {
                                ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
                            }
                        }
                    });
                }
                catch (BusinessException businessException) {
                    return new Status(4, "info.novatec.inspectit.rcp", "Copy of the buffer data to storage failed.", (Throwable)businessException);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/buffer_copy.gif"));
        job.schedule();
        return true;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.newOrExistsingStorageWizardPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectExistingStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage))) {
            this.selectAgentsPage.setCmrRepositoryDefinition(this.cmrRepositoryDefinition);
            this.addLabelWizardPage.setStorageData(this.defineNewStorageWizzardPage.getStorageData());
            return this.selectAgentsPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectExistingStorageWizardPage))) {
            this.selectAgentsPage.setCmrRepositoryDefinition(this.cmrRepositoryDefinition);
            this.addLabelWizardPage.setStorageData(this.selectExistingStorageWizardPage.getSelectedStorageData());
            return this.selectAgentsPage;
        }
        return super.getNextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage)) || ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectExistingStorageWizardPage))) {
            return this.newOrExistsingStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectAgentsPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectExistingStorageWizardPage;
        }
        return super.getPreviousPage(iWizardPage);
    }

    public boolean canFinish() {
        if (!this.newOrExistsingStorageWizardPage.isPageComplete()) {
            return false;
        }
        if (this.newOrExistsingStorageWizardPage.useNewStorage() && !this.defineNewStorageWizzardPage.isPageComplete()) {
            return false;
        }
        if (!this.newOrExistsingStorageWizardPage.useNewStorage() && !this.selectExistingStorageWizardPage.isPageComplete()) {
            return false;
        }
        if (!this.selectAgentsPage.isPageComplete()) {
            return false;
        }
        if (!this.defineProcessorsPage.isPageComplete()) {
            return false;
        }
        return this.timelineWizardPage.isPageComplete();
    }
}

