/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.view.util;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionProviderIntermediate
implements IPostSelectionProvider {
    private final ListenerList selectionListeners = new ListenerList();
    private final ListenerList postSelectionListeners = new ListenerList();
    private ISelectionProvider delegate;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (selectionChangedEvent.getSelectionProvider() == SelectionProviderIntermediate.this.delegate) {
                SelectionProviderIntermediate.this.fireSelectionChanged(selectionChangedEvent.getSelection());
            }
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (selectionChangedEvent.getSelectionProvider() == SelectionProviderIntermediate.this.delegate) {
                SelectionProviderIntermediate.this.firePostSelectionChanged(selectionChangedEvent.getSelection());
            }
        }
    };

    public void setSelectionProviderDelegate(ISelectionProvider iSelectionProvider) {
        if (this.delegate == iSelectionProvider) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            if (this.delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.delegate).removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = iSelectionProvider;
        if (iSelectionProvider != null) {
            iSelectionProvider.addSelectionChangedListener(this.selectionListener);
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.postSelectionListener);
            }
            this.fireSelectionChanged(iSelectionProvider.getSelection());
            this.firePostSelectionChanged(iSelectionProvider.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection iSelection) {
        this.fireSelectionChanged(this.selectionListeners, iSelection);
    }

    protected void firePostSelectionChanged(ISelection iSelection) {
        this.fireSelectionChanged(this.postSelectionListeners, iSelection);
    }

    private void fireSelectionChanged(ListenerList listenerList, ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this.delegate, iSelection);
        Object[] objectArray = listenerList.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.add((Object)iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.remove((Object)iSelectionChangedListener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.delegate.getSelection();
    }

    public void setSelection(ISelection iSelection) {
        if (this.delegate != null) {
            this.delegate.setSelection(iSelection);
        }
    }

    public ISelectionProvider getSelectionProviderDelegate() {
        return this.delegate;
    }
}

