/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.view.tree;

import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.TreeModelManager;
import info.novatec.inspectit.rcp.util.ListenerList;
import java.util.Iterator;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class TreeContentProvider
implements ITreeContentProvider {
    private DeferredTreeContentManager manager;
    private ListenerList<IJobChangeListener> updateCompleteListenerList;

    public Object[] getChildren(Object object) {
        if (this.manager.isDeferredAdapter(object)) {
            Object[] objectArray = this.manager.getChildren(object);
            return objectArray;
        }
        if (object instanceof Composite) {
            Composite composite = (Composite)object;
            return composite.getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        if (object instanceof Composite) {
            Composite composite = (Composite)object;
            return composite.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object == null) {
            return false;
        }
        if (this.manager.isDeferredAdapter(object)) {
            return this.manager.mayHaveChildren(object);
        }
        if (object instanceof Composite) {
            Composite composite = (Composite)object;
            return composite.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object object) {
        TreeModelManager treeModelManager = (TreeModelManager)object;
        return treeModelManager.getRootElements();
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        if (this.updateCompleteListenerList != null) {
            Iterator<IJobChangeListener> iterator = this.updateCompleteListenerList.iterator();
            while (iterator.hasNext()) {
                this.manager.addUpdateCompleteListener(iterator.next());
            }
        }
    }

    public void addUpdateCompleteListener(IJobChangeListener iJobChangeListener) {
        if (this.updateCompleteListenerList == null) {
            this.updateCompleteListenerList = new ListenerList();
        }
        this.updateCompleteListenerList.add(iJobChangeListener);
        if (this.manager != null) {
            this.manager.addUpdateCompleteListener(iJobChangeListener);
        }
    }

    public void removeUpdateCompleteListener(IJobChangeListener iJobChangeListener) {
        if (this.updateCompleteListenerList != null) {
            this.updateCompleteListenerList.remove(iJobChangeListener);
        }
        if (this.manager != null) {
            this.manager.removeUpdateCompleteListener(iJobChangeListener);
        }
    }

    public void dispose() {
    }
}

