/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage.util;

import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.http.TransferDataMonitor;
import info.novatec.inspectit.rcp.storage.util.UploadHttpEntityWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.runtime.SubMonitor;

public class DataUploader {
    private static final String UPLOAD_SERVLET = "/fileupload";

    public void uploadFileToStorageUploads(Path path, Path path2, String string, CmrRepositoryDefinition cmrRepositoryDefinition, SubMonitor subMonitor) throws IOException {
        this.uploadFileToStorageUploads(Collections.singletonList(path), path2, string, cmrRepositoryDefinition, subMonitor);
    }

    public void uploadFileToStorageUploads(List<Path> list, Path path, String string, CmrRepositoryDefinition cmrRepositoryDefinition, SubMonitor subMonitor) throws IOException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Path object2 : list) {
            if (Files.notExists(object2, new LinkOption[0])) {
                throw new IOException("File to upload (" + object2 + ") does not exist.");
            }
            hashMap.put(object2.toString(), Files.size(object2));
        }
        TransferDataMonitor transferDataMonitor = new TransferDataMonitor(subMonitor, hashMap, false);
        String string2 = String.valueOf(this.getServerUri(cmrRepositoryDefinition)) + UPLOAD_SERVLET;
        for (Path path2 : list) {
            DefaultHttpClient defaultHttpClient = null;
            try {
                defaultHttpClient = new DefaultHttpClient();
                HttpPost httpPost = new HttpPost(string2);
                MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
                if (Files.notExists(path2, new LinkOption[0])) {
                    throw new IOException("File to upload (" + path2 + ") does not exist.");
                }
                FileBody fileBody = new FileBody(path2.toFile());
                StringBuilder stringBuilder = new StringBuilder(path.relativize(path2).toString());
                if (string != null) {
                    stringBuilder.insert(0, String.valueOf(string) + File.separator);
                }
                multipartEntity.addPart(stringBuilder.toString(), (ContentBody)fileBody);
                UploadHttpEntityWrapper uploadHttpEntityWrapper = new UploadHttpEntityWrapper((HttpEntity)multipartEntity, transferDataMonitor);
                httpPost.setEntity((HttpEntity)uploadHttpEntityWrapper);
                transferDataMonitor.startTransfer(path2.toString());
                defaultHttpClient.execute((HttpUriRequest)httpPost);
                transferDataMonitor.endTransfer(path2.toString());
            }
            finally {
                if (defaultHttpClient != null) {
                    defaultHttpClient.getConnectionManager().shutdown();
                }
            }
        }
    }

    private String getServerUri(CmrRepositoryDefinition cmrRepositoryDefinition) {
        return "http://" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort();
    }
}

