/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage.util;

import com.esotericsoftware.kryo.io.Input;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.impl.StorageDescriptor;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.http.TransferDataMonitor;
import info.novatec.inspectit.rcp.storage.util.DownloadHttpEntityWrapper;
import info.novatec.inspectit.rcp.storage.util.MultipartEntityUtil;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.nio.stream.ExtendedByteBufferInputStream;
import info.novatec.inspectit.storage.nio.stream.InputStreamProvider;
import info.novatec.inspectit.storage.serializer.ISerializer;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import info.novatec.inspectit.storage.serializer.util.KryoUtil;
import info.novatec.inspectit.storage.util.RangeDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.springframework.http.HttpStatus;

public class DataRetriever {
    private int serializerCount = 3;
    private StorageManager storageManager;
    private SerializationManagerProvider serializationManagerProvider;
    private BlockingQueue<ISerializer> serializerQueue = new LinkedBlockingQueue<ISerializer>();
    private InputStreamProvider streamProvider;

    protected void init() throws Exception {
        int n = 0;
        while (n < this.serializerCount) {
            this.serializerQueue.add((ISerializer)this.serializationManagerProvider.createSerializer());
            ++n;
        }
    }

    public <E extends DefaultData> List<E> getDataViaHttp(CmrRepositoryDefinition cmrRepositoryDefinition, IStorageData iStorageData, List<IStorageDescriptor> list) throws IOException, SerializationException {
        Map<Integer, List<IStorageDescriptor>> map = this.createFilesGroup(list);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.getServerUri(cmrRepositoryDefinition);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        for (Map.Entry<Integer, List<IStorageDescriptor>> entry : map.entrySet()) {
            IStorageDescriptor iStorageDescriptor2;
            HttpGet httpGet = new HttpGet(String.valueOf(string) + this.storageManager.getHttpFileLocation(iStorageData, entry.getKey()));
            StringBuilder stringBuilder = new StringBuilder("bytes=");
            RangeDescriptor rangeDescriptor = null;
            for (IStorageDescriptor iStorageDescriptor2 : entry.getValue()) {
                if (rangeDescriptor == null) {
                    rangeDescriptor = new RangeDescriptor(iStorageDescriptor2);
                    continue;
                }
                if (rangeDescriptor.getEnd() + 1L == iStorageDescriptor2.getPosition()) {
                    rangeDescriptor.setEnd(iStorageDescriptor2.getPosition() + iStorageDescriptor2.getSize() - 1L);
                    continue;
                }
                stringBuilder.append(rangeDescriptor.toString());
                stringBuilder.append(',');
                rangeDescriptor = new RangeDescriptor(iStorageDescriptor2);
            }
            stringBuilder.append(rangeDescriptor);
            httpGet.addHeader("Range", stringBuilder.toString());
            iStorageDescriptor2 = null;
            try {
                iStorageDescriptor2 = this.serializerQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
            Object object = null;
            Input input = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream;
                Object object2;
                HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                HttpEntity httpEntity = httpResponse.getEntity();
                if (MultipartEntityUtil.isMultipart(httpEntity)) {
                    object = httpEntity.getContent();
                    object2 = new MultipartStream((InputStream)object, MultipartEntityUtil.getBoundary(httpEntity).getBytes());
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    boolean bl = object2.skipPreamble();
                    while (bl) {
                        object2.readHeaders();
                        object2.readBodyData((OutputStream)byteArrayOutputStream);
                        input = new Input(byteArrayOutputStream.toByteArray());
                        while (KryoUtil.hasMoreBytes((Input)input)) {
                            Object object3 = iStorageDescriptor2.deserialize(input);
                            DefaultData defaultData = (DefaultData)object3;
                            arrayList.add(defaultData);
                        }
                        bl = object2.readBoundary();
                    }
                    continue;
                }
                input = new Input(EntityUtils.toByteArray((HttpEntity)httpEntity));
                while (KryoUtil.hasMoreBytes((Input)input)) {
                    object2 = iStorageDescriptor2.deserialize(input);
                    byteArrayOutputStream = (DefaultData)object2;
                    arrayList.add(byteArrayOutputStream);
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (input != null) {
                    input.close();
                }
                this.serializerQueue.add((ISerializer)iStorageDescriptor2);
            }
        }
        return arrayList;
    }

    public <E extends DefaultData> List<E> getDataLocally(LocalStorageData localStorageData, List<IStorageDescriptor> list) throws IOException, SerializationException {
        IStorageDescriptor iStorageDescriptor2;
        ExtendedByteBufferInputStream extendedByteBufferInputStream;
        Map<Integer, List<IStorageDescriptor>> map = this.createFilesGroup(list);
        ArrayList<ExtendedByteBufferInputStream> arrayList = new ArrayList<ExtendedByteBufferInputStream>();
        for (Map.Entry<Integer, List<IStorageDescriptor>> object2 : map.entrySet()) {
            extendedByteBufferInputStream = null;
            for (IStorageDescriptor iStorageDescriptor2 : object2.getValue()) {
                if (extendedByteBufferInputStream == null) {
                    extendedByteBufferInputStream = new StorageDescriptor(object2.getKey().intValue());
                    extendedByteBufferInputStream.setPositionAndSize(iStorageDescriptor2.getPosition(), iStorageDescriptor2.getSize());
                    continue;
                }
                if (extendedByteBufferInputStream.join(iStorageDescriptor2)) continue;
                arrayList.add(extendedByteBufferInputStream);
                extendedByteBufferInputStream = new StorageDescriptor(object2.getKey().intValue());
                extendedByteBufferInputStream.setPositionAndSize(iStorageDescriptor2.getPosition(), iStorageDescriptor2.getSize());
            }
            arrayList.add(extendedByteBufferInputStream);
        }
        ArrayList<DefaultData> arrayList2 = new ArrayList<DefaultData>(list.size());
        ISerializer iSerializer = null;
        try {
            iSerializer = this.serializerQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        extendedByteBufferInputStream = null;
        iStorageDescriptor2 = null;
        try {
            extendedByteBufferInputStream = this.streamProvider.getExtendedByteBufferInputStream((IStorageData)localStorageData, arrayList);
            iStorageDescriptor2 = new Input((InputStream)extendedByteBufferInputStream);
            while (KryoUtil.hasMoreBytes((Input)iStorageDescriptor2)) {
                Object object = iSerializer.deserialize((Input)iStorageDescriptor2);
                DefaultData defaultData = (DefaultData)object;
                arrayList2.add(defaultData);
            }
        }
        finally {
            if (iStorageDescriptor2 != null) {
                iStorageDescriptor2.close();
            }
            this.serializerQueue.add(iSerializer);
        }
        return arrayList2;
    }

    public <E extends DefaultData> List<E> getCachedDataViaHttp(CmrRepositoryDefinition cmrRepositoryDefinition, StorageData storageData, int n) throws BusinessException, IOException, SerializationException {
        String string = cmrRepositoryDefinition.getStorageService().getCachedStorageDataFileLocation(storageData, n);
        if (string == null) {
            return null;
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(String.valueOf(this.getServerUri(cmrRepositoryDefinition)) + string);
        ISerializer iSerializer = null;
        try {
            iSerializer = this.serializerQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        InputStream inputStream = null;
        Input input = null;
        try {
            List list;
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = httpEntity.getContent();
            input = new Input(inputStream);
            Object object = iSerializer.deserialize(input);
            List list2 = list = (List)object;
            return list2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (input != null) {
                input.close();
            }
            this.serializerQueue.add(iSerializer);
        }
    }

    /*
     * Exception decompiling
     */
    public <E extends DefaultData> List<E> getCachedDataLocally(LocalStorageData var1_1, int var2_2) throws IOException, SerializationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void downloadAndSaveStorageFiles(CmrRepositoryDefinition cmrRepositoryDefinition, StorageData storageData, final Path path, boolean bl, boolean bl2, SubMonitor subMonitor, StorageFileType ... storageFileTypeArray) throws BusinessException, IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new BusinessException("Download and save storage files for storage " + storageData + " to the path " + path.toString() + ".", (IErrorCode)StorageErrorCodeEnum.FILE_DOES_NOT_EXIST);
        }
        Map<String, Long> map = this.getFilesFromCmr(cmrRepositoryDefinition, storageData, storageFileTypeArray);
        if (MapUtils.isNotEmpty(map)) {
            PostDownloadRunnable postDownloadRunnable = new PostDownloadRunnable(){

                @Override
                public void process(InputStream inputStream, String string) throws IOException {
                    String[] stringArray = string.split("/");
                    Path path2 = path;
                    int n = 2;
                    while (n < stringArray.length) {
                        path2 = path2.resolve(stringArray[n]);
                        ++n;
                    }
                    if (Files.notExists(path2.getParent(), new LinkOption[0])) {
                        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(inputStream, path2, StandardCopyOption.REPLACE_EXISTING);
                }
            };
            this.downloadAndSaveObjects(cmrRepositoryDefinition, map, postDownloadRunnable, bl, bl2, subMonitor);
        }
    }

    public void downloadAndZipStorageFiles(CmrRepositoryDefinition cmrRepositoryDefinition, StorageData storageData, final ZipOutputStream zipOutputStream, boolean bl, boolean bl2, SubMonitor subMonitor, StorageFileType ... storageFileTypeArray) throws BusinessException, IOException {
        Map<String, Long> map = this.getFilesFromCmr(cmrRepositoryDefinition, storageData, storageFileTypeArray);
        PostDownloadRunnable postDownloadRunnable = new PostDownloadRunnable(){

            @Override
            public void process(InputStream inputStream, String string) throws IOException {
                String[] stringArray = string.split("/");
                String string2 = stringArray[stringArray.length - 1];
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
        };
        this.downloadAndSaveObjects(cmrRepositoryDefinition, map, postDownloadRunnable, bl, bl2, subMonitor);
    }

    private Map<String, Long> getFilesFromCmr(CmrRepositoryDefinition cmrRepositoryDefinition, StorageData storageData, StorageFileType ... storageFileTypeArray) throws BusinessException {
        Map map;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (ArrayUtils.contains((Object[])storageFileTypeArray, (Object)StorageFileType.AGENT_FILE)) {
            map = cmrRepositoryDefinition.getStorageService().getAgentFilesLocations(storageData);
            hashMap.putAll(map);
        }
        if (ArrayUtils.contains((Object[])storageFileTypeArray, (Object)StorageFileType.INDEX_FILE)) {
            map = cmrRepositoryDefinition.getStorageService().getIndexFilesLocations(storageData);
            hashMap.putAll(map);
        }
        if (ArrayUtils.contains((Object[])storageFileTypeArray, (Object)StorageFileType.DATA_FILE)) {
            map = cmrRepositoryDefinition.getStorageService().getDataFilesLocations(storageData);
            hashMap.putAll(map);
        }
        if (ArrayUtils.contains((Object[])storageFileTypeArray, (Object)StorageFileType.CACHED_DATA_FILE)) {
            map = cmrRepositoryDefinition.getStorageService().getCachedDataFilesLocations(storageData);
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private void downloadAndSaveObjects(CmrRepositoryDefinition cmrRepositoryDefinition, Map<String, Long> map, PostDownloadRunnable postDownloadRunnable, boolean bl, boolean bl2, SubMonitor subMonitor) throws IOException, BusinessException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        final TransferDataMonitor transferDataMonitor = new TransferDataMonitor(subMonitor, map, bl);
        defaultHttpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                httpResponse.setEntity((HttpEntity)new DownloadHttpEntityWrapper(httpResponse.getEntity(), transferDataMonitor));
            }
        });
        if (bl && bl2) {
            defaultHttpClient.addResponseInterceptor((HttpResponseInterceptor)new GzipHttpResponseInterceptor());
        }
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = String.valueOf(this.getServerUri(cmrRepositoryDefinition)) + string;
            HttpGet httpGet = new HttpGet(string2);
            if (bl) {
                httpGet.addHeader("accept-encoding", "gzip");
            }
            transferDataMonitor.startTransfer(string);
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (HttpStatus.valueOf((int)statusLine.getStatusCode()).series().equals((Object)HttpStatus.Series.SUCCESSFUL)) {
                HttpEntity httpEntity = httpResponse.getEntity();
                Throwable throwable = null;
                Object var18_19 = null;
                try (InputStream inputStream = httpEntity.getContent();){
                    postDownloadRunnable.process(inputStream, string);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            transferDataMonitor.endTransfer(string);
        }
    }

    private String getServerUri(CmrRepositoryDefinition cmrRepositoryDefinition) {
        return "http://" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort();
    }

    private Map<Integer, List<IStorageDescriptor>> createFilesGroup(List<IStorageDescriptor> list) {
        Object object;
        HashMap<Integer, List<IStorageDescriptor>> hashMap = new HashMap<Integer, List<IStorageDescriptor>>();
        for (IStorageDescriptor object2 : list) {
            object = object2.getChannelId();
            ArrayList<IStorageDescriptor> arrayList = (ArrayList<IStorageDescriptor>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<IStorageDescriptor>();
                hashMap.put((Integer)object, arrayList);
            }
            arrayList.add(object2);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (List)entry.getValue();
            Collections.sort(object, new Comparator<IStorageDescriptor>(){

                @Override
                public int compare(IStorageDescriptor iStorageDescriptor, IStorageDescriptor iStorageDescriptor2) {
                    return Long.compare(iStorageDescriptor.getPosition(), iStorageDescriptor2.getPosition());
                }
            });
        }
        return hashMap;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    private static boolean isGZipContentEncoding(HttpEntity httpEntity) {
        Header header = httpEntity.getContentEncoding();
        if (header != null) {
            HeaderElement[] headerElementArray = header.getElements();
            int n = 0;
            while (n < headerElementArray.length) {
                if (headerElementArray[n].getName().equalsIgnoreCase("gzip")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void setSerializerCount(int n) {
        this.serializerCount = n;
    }

    public void setSerializationManagerProvider(SerializationManagerProvider serializationManagerProvider) {
        this.serializationManagerProvider = serializationManagerProvider;
    }

    public void setStreamProvider(InputStreamProvider inputStreamProvider) {
        this.streamProvider = inputStreamProvider;
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public InputStream getContent() throws IOException {
            InputStream inputStream = this.wrappedEntity.getContent();
            return new GZIPInputStream(inputStream);
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class GzipHttpResponseInterceptor
    implements HttpResponseInterceptor {
        private GzipHttpResponseInterceptor() {
        }

        public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            if (DataRetriever.isGZipContentEncoding(httpResponse.getEntity())) {
                httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(httpResponse.getEntity()));
            }
        }
    }

    private static interface PostDownloadRunnable {
        public void process(InputStream var1, String var2) throws IOException;
    }
}

