/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.cmr;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class KryoSimpleHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private SerializationManagerProvider serializationManagerProvider;

    protected void writeRemoteInvocation(RemoteInvocation remoteInvocation, OutputStream outputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Output output = new Output(outputStream);){
                SerializationManager serializationManager = this.serializationManagerProvider.createSerializer();
                serializationManager.serialize((Object)remoteInvocation, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SerializationException serializationException) {
            InspectIT.getDefault().createErrorDialog(serializationException.getMessage(), serializationException, -1);
            throw new IOException(serializationException);
        }
    }

    protected RemoteInvocationResult readRemoteInvocationResult(InputStream inputStream, String string) throws IOException, ClassNotFoundException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Input input = new Input(inputStream);){
                SerializationManager serializationManager = this.serializationManagerProvider.createSerializer();
                return (RemoteInvocationResult)serializationManager.deserialize(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SerializationException serializationException) {
            InspectIT.getDefault().createErrorDialog(serializationException.getMessage(), serializationException, -1);
            throw new IOException(serializationException);
        }
    }

    public SerializationManagerProvider getSerializationManagerProvider() {
        return this.serializationManagerProvider;
    }

    public void setSerializationManagerProvider(SerializationManagerProvider serializationManagerProvider) {
        this.serializationManagerProvider = serializationManagerProvider;
    }
}

