/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository;

import info.novatec.inspectit.cmr.service.ICmrManagementService;
import info.novatec.inspectit.cmr.service.IConfigurationInterfaceService;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.cmr.service.IInvocationDataAccessService;
import info.novatec.inspectit.cmr.service.IJmxDataAccessService;
import info.novatec.inspectit.cmr.service.IServerStatusService;
import info.novatec.inspectit.cmr.service.ISqlDataAccessService;
import info.novatec.inspectit.cmr.service.IStorageService;
import info.novatec.inspectit.cmr.service.ITimerDataAccessService;
import info.novatec.inspectit.cmr.service.cache.CachedDataService;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.service.RefreshEditorsCachedDataService;
import info.novatec.inspectit.rcp.repository.service.cmr.CmrServiceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CmrRepositoryDefinition
implements RepositoryDefinition,
ICmrRepositoryProvider {
    public static final String DEFAULT_NAME = "Local CMR";
    public static final String DEFAULT_IP = "localhost";
    public static final int DEFAULT_PORT = 8182;
    public static final String DEFAULT_DESCRIPTION = "This Central Management Repository (CMR) is automatically added by default when you first start the inspectIT.";
    private final String ip;
    private final int port;
    private OnlineStatus onlineStatus;
    private String registrationIdKey;
    private String name;
    private String description;
    private final CachedDataService cachedDataService;
    private final ISqlDataAccessService sqlDataAccessService;
    private final IInvocationDataAccessService invocationDataAccessService;
    private final IExceptionDataAccessService exceptionDataAccessService;
    private final IServerStatusService serverStatusService;
    private ICmrManagementService cmrManagementService;
    private ITimerDataAccessService timerDataAccessService;
    private IHttpTimerDataAccessService httpTimerDataAccessService;
    private IGlobalDataAccessService globalDataAccessService;
    private IJmxDataAccessService jmxDataAccessService;
    private IStorageService storageService;
    private IConfigurationInterfaceService configurationInterfaceService;
    private List<CmrRepositoryChangeListener> cmrRepositoryChangeListeners = new ArrayList<CmrRepositoryChangeListener>(1);

    public CmrRepositoryDefinition(String string, int n) {
        this(string, n, "Undefined");
    }

    public CmrRepositoryDefinition(String string, int n, String string2) {
        this.ip = string;
        this.port = n;
        this.onlineStatus = OnlineStatus.UNKNOWN;
        this.name = string2;
        CmrServiceProvider cmrServiceProvider = InspectIT.getService(CmrServiceProvider.class);
        this.sqlDataAccessService = cmrServiceProvider.getSqlDataAccessService(this);
        this.serverStatusService = cmrServiceProvider.getServerStatusService(this);
        this.invocationDataAccessService = cmrServiceProvider.getInvocationDataAccessService(this);
        this.exceptionDataAccessService = cmrServiceProvider.getExceptionDataAccessService(this);
        this.httpTimerDataAccessService = cmrServiceProvider.getHttpTimerDataAccessService(this);
        this.cmrManagementService = cmrServiceProvider.getCmrManagementService(this);
        this.timerDataAccessService = cmrServiceProvider.getTimerDataAccessService(this);
        this.globalDataAccessService = cmrServiceProvider.getGlobalDataAccessService(this);
        this.storageService = cmrServiceProvider.getStorageService(this);
        this.configurationInterfaceService = cmrServiceProvider.getConfigurationInterfaceService(this);
        this.jmxDataAccessService = cmrServiceProvider.getJmxDataAccessService(this);
        this.cachedDataService = new RefreshEditorsCachedDataService(this.globalDataAccessService, this);
    }

    public CachedDataService getCachedDataService() {
        return this.cachedDataService;
    }

    @Override
    public IExceptionDataAccessService getExceptionDataAccessService() {
        return this.exceptionDataAccessService;
    }

    @Override
    public ISqlDataAccessService getSqlDataAccessService() {
        return this.sqlDataAccessService;
    }

    @Override
    public IInvocationDataAccessService getInvocationDataAccessService() {
        return this.invocationDataAccessService;
    }

    public ICmrManagementService getCmrManagementService() {
        return this.cmrManagementService;
    }

    @Override
    public ITimerDataAccessService getTimerDataAccessService() {
        return this.timerDataAccessService;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    @Override
    public IHttpTimerDataAccessService getHttpTimerDataAccessService() {
        return this.httpTimerDataAccessService;
    }

    @Override
    public IGlobalDataAccessService getGlobalDataAccessService() {
        return this.globalDataAccessService;
    }

    public IConfigurationInterfaceService getConfigurationInterfaceService() {
        return this.configurationInterfaceService;
    }

    @Override
    public IJmxDataAccessService getJmxDataAccessService() {
        return this.jmxDataAccessService;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCmrRepositoryChangeListener(CmrRepositoryChangeListener cmrRepositoryChangeListener) {
        List<CmrRepositoryChangeListener> list = this.cmrRepositoryChangeListeners;
        synchronized (list) {
            if (!this.cmrRepositoryChangeListeners.contains(cmrRepositoryChangeListener)) {
                this.cmrRepositoryChangeListeners.add(cmrRepositoryChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCmrRepositoryChangeListener(CmrRepositoryChangeListener cmrRepositoryChangeListener) {
        List<CmrRepositoryChangeListener> list = this.cmrRepositoryChangeListeners;
        synchronized (list) {
            this.cmrRepositoryChangeListeners.remove(cmrRepositoryChangeListener);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public String getVersion() {
        if (this.onlineStatus != OnlineStatus.OFFLINE) {
            try {
                return this.serverStatusService.getVersion();
            }
            catch (Exception exception) {
                return "unknown";
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeOnlineStatus(OnlineStatus onlineStatus) {
        if (this.onlineStatus.canChangeTo(onlineStatus)) {
            OnlineStatus onlineStatus2 = this.onlineStatus;
            this.onlineStatus = onlineStatus;
            List<CmrRepositoryChangeListener> list = this.cmrRepositoryChangeListeners;
            synchronized (list) {
                for (CmrRepositoryChangeListener cmrRepositoryChangeListener : this.cmrRepositoryChangeListeners) {
                    cmrRepositoryChangeListener.repositoryOnlineStatusUpdated(this, onlineStatus2, onlineStatus);
                }
            }
            return true;
        }
        return false;
    }

    public void refreshOnlineStatus() {
        this.changeOnlineStatus(OnlineStatus.CHECKING);
        boolean bl = this.isOnline();
        if (bl) {
            this.changeOnlineStatus(OnlineStatus.ONLINE);
        } else {
            this.changeOnlineStatus(OnlineStatus.OFFLINE);
        }
    }

    private boolean isOnline() {
        try {
            IServerStatusService.ServerStatus serverStatus = this.serverStatusService.getServerStatus();
            if (IServerStatusService.ServerStatus.SERVER_ONLINE == serverStatus) {
                this.checkKey(serverStatus.getRegistrationIdsValidationKey());
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this;
    }

    private void checkKey(String string) {
        boolean bl = false;
        if (this.registrationIdKey == null) {
            this.registrationIdKey = string;
        } else {
            bl = !Objects.equals(this.registrationIdKey, string);
            this.registrationIdKey = string;
        }
        if (bl) {
            this.cachedDataService.triggerRefreshIdents();
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ip == null ? 0 : this.ip.hashCode());
        n = 31 * n + this.port;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)object;
        if (this.ip == null ? cmrRepositoryDefinition.ip != null : !this.ip.equals(cmrRepositoryDefinition.ip)) {
            return false;
        }
        return this.port == cmrRepositoryDefinition.port;
    }

    public String toString() {
        return "Repository definition :: Name=" + this.name + " IP=" + this.ip + " Port=" + this.port;
    }

    public static enum OnlineStatus {
        UNKNOWN,
        OFFLINE,
        CHECKING,
        ONLINE;


        public boolean canChangeTo(OnlineStatus onlineStatus) {
            if (this.equals((Object)onlineStatus)) {
                return false;
            }
            if (onlineStatus.equals((Object)UNKNOWN)) {
                return false;
            }
            switch (this) {
                case OFFLINE: {
                    if (onlineStatus.equals((Object)ONLINE)) {
                        return false;
                    }
                }
                case ONLINE: {
                    if (!onlineStatus.equals((Object)OFFLINE)) break;
                    return false;
                }
            }
            return true;
        }
    }
}

