/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property.control.impl;

import info.novatec.inspectit.cmr.property.configuration.impl.LongProperty;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.property.IPropertyUpdateListener;
import info.novatec.inspectit.rcp.property.control.AbstractPropertyControl;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LongPropertyControl
extends AbstractPropertyControl<LongProperty, Long> {
    private Text text;

    public LongPropertyControl(LongProperty longProperty, IPropertyUpdateListener iPropertyUpdateListener) {
        super(longProperty, iPropertyUpdateListener);
    }

    @Override
    public Control createControl(Composite composite) {
        this.text = new Text(composite, 133120);
        this.text.setText(NumberFormatter.formatLong((Long)((LongProperty)this.property).getValue()));
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                String string = LongPropertyControl.this.text.getText();
                String string2 = verifyEvent.text;
                String string3 = String.valueOf(string.substring(0, verifyEvent.start)) + string2 + string.substring(verifyEvent.end, string.length());
                if (StringUtils.isNotBlank((String)string3)) {
                    if (1 == string3.length() && '-' == string3.charAt(0)) {
                        return;
                    }
                    try {
                        Long.parseLong(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        verifyEvent.doit = false;
                        return;
                    }
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = LongPropertyControl.this.text.getText();
                if (!(string.isEmpty() || string.charAt(0) == '-' && string.length() <= 1)) {
                    Long l = Long.parseLong(string);
                    LongPropertyControl.this.sendPropertyUpdateEvent(l);
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = LongPropertyControl.this.text.getText();
                if (string.isEmpty()) {
                    LongPropertyControl.this.text.setText(NumberFormatter.formatLong((Long)LongPropertyControl.this.getLastCorrectValue()));
                }
            }
        });
        return this.text;
    }

    @Override
    protected void showDefaultValue() {
        this.text.setText(NumberFormatter.formatLong(((LongProperty)this.property).getDefaultValue()));
    }
}

