/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model.storage;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.GroupedLabelsComposite;
import info.novatec.inspectit.rcp.model.storage.StorageLeaf;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class StorageTreeModelManager {
    private Map<StorageData, CmrRepositoryDefinition> storageRepositoryMap;
    private AbstractStorageLabelType<?> storageLabelType;

    public StorageTreeModelManager(Map<StorageData, CmrRepositoryDefinition> map, AbstractStorageLabelType<?> abstractStorageLabelType) {
        this.storageRepositoryMap = map;
        this.storageLabelType = abstractStorageLabelType;
    }

    public Object[] getRootObjects() {
        if (this.storageRepositoryMap == null || this.storageRepositoryMap.isEmpty()) {
            return new Object[0];
        }
        if (this.storageLabelType != null) {
            Map.Entry<StorageData, CmrRepositoryDefinition> entry2;
            GroupedLabelsComposite groupedLabelsComposite = new GroupedLabelsComposite();
            groupedLabelsComposite.setName("Unknown");
            groupedLabelsComposite.setImage(ImageFormatter.getImageForLabel(this.storageLabelType));
            boolean bl = false;
            HashMap<String, Composite> hashMap = new HashMap<String, Composite>();
            for (Map.Entry<StorageData, CmrRepositoryDefinition> entry2 : this.storageRepositoryMap.entrySet()) {
                List list = ((StorageData)entry2.getKey()).getLabels(this.storageLabelType);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (AbstractStorageLabel abstractStorageLabel : list) {
                        Composite composite = (Composite)hashMap.get(TextFormatter.getLabelValue(abstractStorageLabel, true));
                        if (composite == null) {
                            composite = new GroupedLabelsComposite(abstractStorageLabel);
                            composite.setName(String.valueOf(TextFormatter.getLabelName(abstractStorageLabel)) + ": " + TextFormatter.getLabelValue(abstractStorageLabel, true));
                            composite.setImage(ImageFormatter.getImageForLabel(this.storageLabelType));
                            hashMap.put(TextFormatter.getLabelValue(abstractStorageLabel, true), composite);
                        }
                        StorageLeaf storageLeaf = new StorageLeaf((StorageData)entry2.getKey(), (CmrRepositoryDefinition)entry2.getValue());
                        storageLeaf.setParent(composite);
                        composite.addChild(storageLeaf);
                    }
                    continue;
                }
                groupedLabelsComposite.addChild(new StorageLeaf((StorageData)entry2.getKey(), (CmrRepositoryDefinition)entry2.getValue()));
                bl = true;
            }
            entry2 = new ArrayList();
            ((ArrayList)((Object)entry2)).addAll(hashMap.values());
            if (bl) {
                ((ArrayList)((Object)entry2)).add(groupedLabelsComposite);
            }
            return ((ArrayList)((Object)entry2)).toArray(new Composite[((ArrayList)((Object)entry2)).size()]);
        }
        HashMap<CmrRepositoryDefinition, Composite> hashMap = new HashMap<CmrRepositoryDefinition, Composite>();
        for (Map.Entry<StorageData, CmrRepositoryDefinition> entry : this.storageRepositoryMap.entrySet()) {
            CmrRepositoryDefinition cmrRepositoryDefinition = entry.getValue();
            Composite composite = (Composite)hashMap.get(cmrRepositoryDefinition);
            if (composite == null) {
                composite = new Composite();
                composite.setName(cmrRepositoryDefinition.getName());
                composite.setImage(InspectIT.getDefault().getImage("/icons/selfmade/server_online_16x16.png"));
                hashMap.put(cmrRepositoryDefinition, composite);
            }
            StorageLeaf storageLeaf = new StorageLeaf(entry.getKey(), entry.getValue());
            storageLeaf.setParent(composite);
            composite.addChild(storageLeaf);
        }
        return hashMap.values().toArray(new Composite[hashMap.values().size()]);
    }
}

