/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model.storage;

import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.storage.LocalStorageLeaf;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class LocalStorageTreeModelManager {
    private Collection<LocalStorageData> localStorageDataCollection;
    private AbstractStorageLabelType<?> storageLabelType;

    public LocalStorageTreeModelManager(Collection<LocalStorageData> collection, AbstractStorageLabelType<?> abstractStorageLabelType) {
        this.localStorageDataCollection = collection;
        this.storageLabelType = abstractStorageLabelType;
    }

    public Object[] getRootObjects() {
        if (CollectionUtils.isEmpty(this.localStorageDataCollection)) {
            return new Object[0];
        }
        if (this.storageLabelType != null) {
            LocalStorageData localStorageData2;
            Composite composite = new Composite();
            composite.setName("Unknown");
            composite.setImage(ImageFormatter.getImageForLabel(this.storageLabelType));
            boolean bl = false;
            HashMap<String, Composite> hashMap = new HashMap<String, Composite>();
            for (LocalStorageData localStorageData2 : this.localStorageDataCollection) {
                List list = localStorageData2.getLabels(this.storageLabelType);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (AbstractStorageLabel abstractStorageLabel : list) {
                        Composite composite2 = (Composite)hashMap.get(TextFormatter.getLabelValue(abstractStorageLabel, true));
                        if (composite2 == null) {
                            composite2 = new Composite();
                            composite2.setName(String.valueOf(TextFormatter.getLabelName(abstractStorageLabel)) + ": " + TextFormatter.getLabelValue(abstractStorageLabel, true));
                            composite2.setImage(ImageFormatter.getImageForLabel(this.storageLabelType));
                            hashMap.put(TextFormatter.getLabelValue(abstractStorageLabel, true), composite2);
                        }
                        LocalStorageLeaf localStorageLeaf = new LocalStorageLeaf(localStorageData2);
                        localStorageLeaf.setParent(composite2);
                        composite2.addChild(localStorageLeaf);
                    }
                    continue;
                }
                composite.addChild(new LocalStorageLeaf(localStorageData2));
                bl = true;
            }
            localStorageData2 = new ArrayList();
            localStorageData2.addAll(hashMap.values());
            if (bl) {
                localStorageData2.add(composite);
            }
            return localStorageData2.toArray(new Composite[localStorageData2.size()]);
        }
        ArrayList<LocalStorageLeaf> arrayList = new ArrayList<LocalStorageLeaf>();
        for (LocalStorageData localStorageData : this.localStorageDataCollection) {
            arrayList.add(new LocalStorageLeaf(localStorageData));
        }
        return arrayList.toArray();
    }
}

