/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.MethodIdentToSensorType;
import info.novatec.inspectit.cmr.model.MethodSensorTypeIdent;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredClassComposite;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public class FilteredDeferredClassComposite
extends DeferredClassComposite {
    private SensorTypeEnum sensorTypeEnumToShow;

    public FilteredDeferredClassComposite(SensorTypeEnum sensorTypeEnum) {
        this.sensorTypeEnumToShow = sensorTypeEnum;
    }

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            List<MethodIdent> list = this.getMethods();
            Composite composite = (Composite)object;
            iProgressMonitor.beginTask("Loading of Method Elements...", list.size());
            for (MethodIdent methodIdent : list) {
                for (MethodIdentToSensorType methodIdentToSensorType : methodIdent.getMethodIdentToSensorTypes()) {
                    Object object2;
                    MethodSensorTypeIdent methodSensorTypeIdent;
                    String string;
                    SensorTypeEnum sensorTypeEnum;
                    if (this.isHideInactiveInstrumentations() && !methodIdentToSensorType.isActive() || (sensorTypeEnum = SensorTypeEnum.get(string = (methodSensorTypeIdent = methodIdentToSensorType.getMethodSensorTypeIdent()).getFullyQualifiedClassName())) != this.sensorTypeEnumToShow) continue;
                    if (!sensorTypeEnum.isOpenable()) break;
                    Leaf leaf = new Leaf();
                    leaf.setEnabled(methodIdentToSensorType.isActive());
                    if (methodIdent.getParameters() != null) {
                        object2 = methodIdent.getParameters().toString();
                        object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                        leaf.setName(String.format("%s(%s)", methodIdent.getMethodName(), object2));
                    } else {
                        leaf.setName(String.format("%s(%s)", methodIdent.getMethodName(), ""));
                    }
                    leaf.setImage(ModifiersImageFactory.getImage(methodIdent.getModifiers()));
                    object2 = new InputDefinition();
                    ((InputDefinition)object2).setRepositoryDefinition(this.getRepositoryDefinition());
                    ((InputDefinition)object2).setId(sensorTypeEnum);
                    EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
                    editorPropertiesData.setSensorImage(sensorTypeEnum.getImage());
                    editorPropertiesData.setSensorName(sensorTypeEnum.getDisplayName());
                    editorPropertiesData.setViewName(TextFormatter.getMethodString(methodIdent));
                    editorPropertiesData.setViewImage(ModifiersImageFactory.getImage(methodIdent.getModifiers()));
                    ((InputDefinition)object2).setEditorPropertiesData(editorPropertiesData);
                    InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
                    idDefinition.setPlatformId(methodIdent.getPlatformIdent().getId());
                    idDefinition.setSensorTypeId(methodSensorTypeIdent.getId());
                    idDefinition.setMethodId(methodIdent.getId());
                    ((InputDefinition)object2).setIdDefinition(idDefinition);
                    leaf.setInputDefinition((InputDefinition)object2);
                    iElementCollector.add((Object)leaf, iProgressMonitor);
                    composite.addChild(leaf);
                    break;
                }
                iProgressMonitor.worked(1);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected boolean select(MethodIdent methodIdent) {
        for (MethodIdentToSensorType methodIdentToSensorType : methodIdent.getMethodIdentToSensorTypes()) {
            SensorTypeEnum sensorTypeEnum = SensorTypeEnum.get(methodIdentToSensorType.getMethodSensorTypeIdent().getFullyQualifiedClassName());
            if (!ObjectUtils.equals((Object)((Object)sensorTypeEnum), (Object)((Object)this.sensorTypeEnumToShow))) continue;
            return super.select(methodIdent);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.sensorTypeEnumToShow});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FilteredDeferredClassComposite filteredDeferredClassComposite = (FilteredDeferredClassComposite)object;
        return Objects.equal((Object)((Object)this.sensorTypeEnumToShow), (Object)((Object)filteredDeferredClassComposite.sensorTypeEnumToShow));
    }
}

