/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class NavigateToJmxPlottingHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        AbstractRootEditor abstractRootEditor = (AbstractRootEditor)HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        RepositoryDefinition repositoryDefinition = abstractRootEditor.getInputDefinition().getRepositoryDefinition();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)iStructuredSelection.getFirstElement();
        if (jmxSensorValueData != null) {
            JmxDefinitionDataIdent jmxDefinitionDataIdent = repositoryDefinition.getCachedDataService().getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setId(SensorTypeEnum.CHARTING_JMX_SENSOR_DATA);
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(SensorTypeEnum.CHARTING_JMX_SENSOR_DATA.getImage());
            editorPropertiesData.setSensorName(String.format("Chart - %s", jmxDefinitionDataIdent.getmBeanAttributeName()));
            editorPropertiesData.setPartNameFlag(EditorPropertiesData.PartType.SENSOR);
            editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/fugue/bean.png"));
            editorPropertiesData.setViewName(TextFormatter.getJmxDefinitionString(jmxDefinitionDataIdent));
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(jmxDefinitionDataIdent.getPlatformIdent().getId());
            idDefinition.setSensorTypeId(jmxSensorValueData.getSensorTypeIdent());
            idDefinition.setJmxDefinitionId(jmxDefinitionDataIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.openView");
            ExecutionEvent executionEvent2 = iHandlerService.createExecutionEvent(command, new Event());
            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent2.getApplicationContext();
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.openView.input", (Object)inputDefinition);
            try {
                command.executeWithChecks(executionEvent2);
            }
            catch (Exception exception) {
                InspectIT.getDefault().createErrorDialog(exception.getMessage(), exception, -1);
            }
        }
        return null;
    }
}

