/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryAndAgentProvider;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.CopyBufferToStorageWizard;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyBufferToStorageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection) {
            CmrRepositoryDefinition cmrRepositoryDefinition = null;
            List<PlatformIdent> list = Collections.emptyList();
            Object object = ((StructuredSelection)iSelection).getFirstElement();
            if (object instanceof ICmrRepositoryProvider) {
                cmrRepositoryDefinition = ((ICmrRepositoryProvider)object).getCmrRepositoryDefinition();
            } else if (object instanceof ICmrRepositoryAndAgentProvider) {
                cmrRepositoryDefinition = ((ICmrRepositoryAndAgentProvider)object).getCmrRepositoryDefinition();
                list = Collections.singletonList(((ICmrRepositoryAndAgentProvider)object).getPlatformIdent());
            }
            if (cmrRepositoryDefinition != null) {
                String string;
                Object object2;
                try {
                    object2 = cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData();
                    if (object2.isWarnSpaceLeftActive()) {
                        string = NumberFormatter.humanReadableByteCount(object2.getStorageDataSpaceLeft());
                        if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Confirm", (String)("For selected CMR there is an active warning about insufficient storage space left. Only " + string + " are left on the target server, are you sure you want to continue?"))) {
                            return null;
                        }
                    }
                }
                catch (Exception exception) {}
                object2 = new CopyBufferToStorageWizard(cmrRepositoryDefinition, list);
                string = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (IWizard)object2);
                string.open();
            }
        }
        return null;
    }
}

