/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.storage.StorageData;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class CloseStorageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Object object;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection && (object = ((StructuredSelection)iSelection).getFirstElement()) instanceof IStorageDataProvider) {
            StorageData storageData = ((IStorageDataProvider)object).getStorageData();
            CmrRepositoryDefinition cmrRepositoryDefinition = ((IStorageDataProvider)object).getCmrRepositoryDefinition();
            MessageBox messageBox = new MessageBox(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), 292);
            messageBox.setText("Confirm Finalization");
            messageBox.setMessage("Are you sure you want to finalize the selected storage? Writing will not be possible after finalization. Note that finalization process will wait for all ongoing writing tasks to be finished.");
            if (32 == messageBox.open()) {
                FinalizeStorageJob finalizeStorageJob = new FinalizeStorageJob(storageData, cmrRepositoryDefinition);
                finalizeStorageJob.schedule();
            }
        }
        return null;
    }

    protected static class FinalizeStorageJob
    extends Job {
        private static final long TASKS_CHECK_SLEEP_TIME = 1000L;
        private StorageData storageData;
        private CmrRepositoryDefinition cmrRepositoryDefinition;

        public FinalizeStorageJob(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
            super("Finalizing storage " + storageData);
            this.storageData = storageData;
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            this.setUser(true);
            this.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/eclipse/storage_finalize.gif"));
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                return Status.CANCEL_STATUS;
            }
            int n = (int)this.cmrRepositoryDefinition.getStorageService().getStorageQueuedWriteTaskCount(this.storageData);
            String string = n > 0 ? "Waiting for " + n + " writing tasks to finish and finalizing storage '" + this.storageData.getName() + "'" : "Finalizing storage '" + this.storageData + "'";
            iProgressMonitor.beginTask(string, n + 1);
            Job job = new Job("Execute finalization"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        FinalizeStorageJob.this.cmrRepositoryDefinition.getStorageService().closeStorage(FinalizeStorageJob.this.storageData);
                        return Status.OK_STATUS;
                    }
                    catch (BusinessException businessException) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Selected storage " + FinalizeStorageJob.this.storageData + " could not be finalized.", (Throwable)businessException);
                    }
                }
            };
            job.setUser(false);
            job.schedule();
            while (job.getState() != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (job.getState() == 0) {
                    iProgressMonitor.worked(n);
                    continue;
                }
                int n2 = (int)this.cmrRepositoryDefinition.getStorageService().getStorageQueuedWriteTaskCount(this.storageData);
                iProgressMonitor.worked(n - n2);
                n = n2;
            }
            iProgressMonitor.worked(1);
            iProgressMonitor.done();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
                    if (iViewPart instanceof StorageManagerView) {
                        ((StorageManagerView)iViewPart).refresh(FinalizeStorageJob.this.cmrRepositoryDefinition);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

