/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.formatter;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.ci.assignment.AbstractClassSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.TimerMethodSensorAssignment;
import info.novatec.inspectit.ci.context.AbstractContextCapture;
import info.novatec.inspectit.ci.context.impl.FieldContextCapture;
import info.novatec.inspectit.ci.context.impl.ParameterContextCapture;
import info.novatec.inspectit.ci.context.impl.ReturnContextCapture;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.exception.impl.ExceptionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.ConnectionMetaDataSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.ConnectionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.HttpSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.InvocationSequenceSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.Log4jLoggingSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.PreparedStatementParameterSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.PreparedStatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.StatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.TimerSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.ClassLoadingSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.CompilationSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.CpuSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.MemorySensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.RuntimeSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.SystemSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.ThreadSensorConfig;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.communication.data.cmr.WritingStatus;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.resource.CombinedIcon;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.type.AbstractCustomStorageLabelType;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.AssigneeLabelType;
import info.novatec.inspectit.storage.label.type.impl.CreationDateLabelType;
import info.novatec.inspectit.storage.label.type.impl.DataTimeFrameLabelType;
import info.novatec.inspectit.storage.label.type.impl.ExploredByLabelType;
import info.novatec.inspectit.storage.label.type.impl.RatingLabelType;
import info.novatec.inspectit.storage.label.type.impl.StatusLabelType;
import info.novatec.inspectit.storage.label.type.impl.UseCaseLabelType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public final class ImageFormatter {
    public static final String[] LABEL_ICONS = new String[]{"/icons/eclipse/home_nav.gif", "/icons/eclipse/message.gif", "/icons/eclipse/warning_obj.gif", "/icons/eclipse/debugtt_obj.gif", "/icons/eclipse/calendar.gif", "/icons/eclipse/user.gif", "/icons/eclipse/complete_status.gif", "/icons/eclipse/class_obj.gif", "/icons/eclipse/package_obj.gif", "/icons/eclipse/methdef_obj.gif", "/icons/fugue/memory.png", "/icons/fugue/processor.png", "/icons/eclipse/debugt_obj.gif", "/icons/fugue/database-sql.png", "/icons/eclipse/calendar.gif", "/icons/eclipse/business.gif", "/icons/eclipse/ihigh_obj.gif", "/icons/eclipse/alert_obj.gif", "/icons/eclipse/insp_sbook.gif", "/icons/eclipse/method_time.gif", "/icons/eclipse/build.gif", "/icons/eclipse/trash.gif", "/icons/eclipse/properties.gif", "/icons/eclipse/time.gif", "/icons/eclipse/font.gif", "/icons/eclipse/info_obj.gif", "/icons/eclipse/filter_ps.gif", "/icons/eclipse/url.gif"};

    private ImageFormatter() {
    }

    public static Image getImageForLabel(AbstractStorageLabelType<?> abstractStorageLabelType) {
        return InspectIT.getDefault().getImage(ImageFormatter.getImageKeyForLabel(abstractStorageLabelType));
    }

    public static ImageDescriptor getImageDescriptorForLabel(AbstractStorageLabelType<?> abstractStorageLabelType) {
        return InspectIT.getDefault().getImageDescriptor(ImageFormatter.getImageKeyForLabel(abstractStorageLabelType));
    }

    private static String getImageKeyForLabel(AbstractStorageLabelType<?> abstractStorageLabelType) {
        if (AssigneeLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/user.gif";
        }
        if (CreationDateLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/calendar.gif";
        }
        if (ExploredByLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/read_obj.gif";
        }
        if (RatingLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/ihigh_obj.gif";
        }
        if (StatusLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/alert_obj.gif";
        }
        if (UseCaseLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/business.gif";
        }
        if (DataTimeFrameLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "/icons/eclipse/timeframe.gif";
        }
        if (abstractStorageLabelType instanceof AbstractCustomStorageLabelType) {
            AbstractCustomStorageLabelType abstractCustomStorageLabelType = (AbstractCustomStorageLabelType)abstractStorageLabelType;
            if (abstractCustomStorageLabelType.getImageKey() != null && InspectIT.getDefault().getImage(abstractCustomStorageLabelType.getImageKey()) != null) {
                return abstractCustomStorageLabelType.getImageKey();
            }
            if (Boolean.class.equals((Object)abstractCustomStorageLabelType.getValueClass())) {
                return "/icons/eclipse/complete_status.gif";
            }
            if (Date.class.equals((Object)abstractCustomStorageLabelType.getValueClass())) {
                return "/icons/eclipse/calendar.gif";
            }
            if (Number.class.equals((Object)abstractCustomStorageLabelType.getValueClass())) {
                return "/icons/eclipse/number.gif";
            }
            if (String.class.equals((Object)abstractCustomStorageLabelType.getValueClass())) {
                return "/icons/eclipse/font.gif";
            }
        }
        return "/icons/eclipse/disabled_co.gif";
    }

    public static Image getImageForStorageLeaf(StorageData storageData) {
        if (storageData.getState() == StorageData.StorageState.CREATED_NOT_OPENED) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage.gif");
        }
        if (storageData.getState() == StorageData.StorageState.OPENED) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage_writable.gif");
        }
        if (storageData.getState() == StorageData.StorageState.RECORDING) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage_recording.gif");
        }
        if (storageData.getState() == StorageData.StorageState.CLOSED) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage_readable.gif");
        }
        return null;
    }

    public static Image getCmrRepositoryImage(CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
            if (bl) {
                return InspectIT.getDefault().getImage("/icons/selfmade/server_online_16x16.png");
            }
            return InspectIT.getDefault().getImage("/icons/selfmade/server_online.png");
        }
        if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            if (bl) {
                return InspectIT.getDefault().getImage("/icons/selfmade/server_offline_16x16.png");
            }
            return InspectIT.getDefault().getImage("/icons/selfmade/server_offline.png");
        }
        if (bl) {
            return InspectIT.getDefault().getImage("/icons/selfmade/server_refresh_16x16.png");
        }
        return InspectIT.getDefault().getImage("/icons/selfmade/server_refresh.png");
    }

    public static Image getStorageRepositoryImage(StorageRepositoryDefinition storageRepositoryDefinition) {
        LocalStorageData localStorageData = storageRepositoryDefinition.getLocalStorageData();
        if (localStorageData.isFullyDownloaded()) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage_download.gif");
        }
        if (storageRepositoryDefinition.getCmrRepositoryDefinition().getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return InspectIT.getDefault().getImage("/icons/eclipse/storage_available.gif");
        }
        return InspectIT.getDefault().getImage("/icons/eclipse/storage_na.gif");
    }

    public static Image getWritingStatusImage(WritingStatus writingStatus) {
        if (writingStatus == null) {
            return null;
        }
        switch (writingStatus) {
            case GOOD: {
                return InspectIT.getDefault().getImage("/icons/eclipse/flag.gif");
            }
            case MEDIUM: {
                return InspectIT.getDefault().getImage("/icons/eclipse/warning_obj.gif");
            }
            case BAD: {
                return InspectIT.getDefault().getImage("/icons/eclipse/alert_obj.gif");
            }
        }
        return null;
    }

    public static Image getOverlayedEditorImage(Image image, RepositoryDefinition repositoryDefinition, ResourceManager resourceManager) {
        if (repositoryDefinition instanceof CmrRepositoryDefinition) {
            return image;
        }
        if (repositoryDefinition instanceof StorageRepositoryDefinition) {
            ImageDescriptor imageDescriptor = InspectIT.getDefault().getImageDescriptor("/icons/eclipse/storage_overlay.gif");
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[3] = imageDescriptor;
            DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(image, imageDescriptorArray);
            Image image2 = resourceManager.createImage((ImageDescriptor)decorationOverlayIcon);
            return image2;
        }
        return null;
    }

    public static Image getCombinedImage(ResourceManager resourceManager, int n, ImageDescriptor ... imageDescriptorArray) {
        return ImageFormatter.getCombinedImage(resourceManager, n, 0, 0, imageDescriptorArray);
    }

    public static Image getCombinedImage(ResourceManager resourceManager, int n, int n2, int n3, ImageDescriptor ... imageDescriptorArray) {
        CombinedIcon combinedIcon = new CombinedIcon(imageDescriptorArray, n, n2, n3);
        Image image = resourceManager.createImage((ImageDescriptor)combinedIcon);
        return image;
    }

    public static Image getAgentImage(AgentStatusData agentStatusData) {
        if (agentStatusData != null) {
            switch (agentStatusData.getAgentConnection()) {
                case CONNECTED: {
                    if (agentStatusData.getMillisSinceLastData() != null) {
                        long l = agentStatusData.getMillisSinceLastData();
                        if (l > 60000L) {
                            return InspectIT.getDefault().getImage("/icons/eclipse/agent_not_sending.gif");
                        }
                        return InspectIT.getDefault().getImage("/icons/eclipse/agent_active.gif");
                    }
                    return InspectIT.getDefault().getImage("/icons/eclipse/agent_not_sending.gif");
                }
                case NO_KEEP_ALIVE: {
                    return InspectIT.getDefault().getImage("/icons/eclipse/agent_no_keepalive.png");
                }
            }
            return InspectIT.getDefault().getImage("/icons/eclipse/agent_na.gif");
        }
        return InspectIT.getDefault().getImage("/icons/eclipse/agent_na.gif");
    }

    public static Image getSensorConfigImage(ISensorConfig iSensorConfig) {
        return ImageFormatter.getSensorConfigImage(iSensorConfig.getClass());
    }

    public static Image getSensorConfigImage(Class<? extends ISensorConfig> clazz) {
        if (ObjectUtils.equals(clazz, ExceptionSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/exceptiontracer.gif");
        }
        if (ObjectUtils.equals(clazz, ConnectionMetaDataSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
        }
        if (ObjectUtils.equals(clazz, ConnectionSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
        }
        if (ObjectUtils.equals(clazz, HttpSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/discovery.gif");
        }
        if (ObjectUtils.equals(clazz, InvocationSequenceSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/arrow-switch.png");
        }
        if (ObjectUtils.equals(clazz, PreparedStatementParameterSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
        }
        if (ObjectUtils.equals(clazz, PreparedStatementSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
        }
        if (ObjectUtils.equals(clazz, StatementSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
        }
        if (ObjectUtils.equals(clazz, TimerSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/method_time.gif");
        }
        if (ObjectUtils.equals(clazz, Log4jLoggingSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/log.gif");
        }
        if (ObjectUtils.equals(clazz, ClassLoadingSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif");
        }
        if (ObjectUtils.equals(clazz, CompilationSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/workset.gif");
        }
        if (ObjectUtils.equals(clazz, CpuSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/processor.png");
        }
        if (ObjectUtils.equals(clazz, MemorySensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/memory.png");
        }
        if (ObjectUtils.equals(clazz, RuntimeSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/resource-monitor.png");
        }
        if (ObjectUtils.equals(clazz, SystemSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png");
        }
        if (ObjectUtils.equals(clazz, ThreadSensorConfig.class)) {
            return InspectIT.getDefault().getImage("/icons/eclipse/debugt_obj.gif");
        }
        return null;
    }

    public static Image getMethodVisibilityImage(ResourceManager resourceManager, MethodSensorAssignment methodSensorAssignment) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[]{methodSensorAssignment.isPublicModifier() ? InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpub_obj.gif") : ImageDescriptor.createWithFlags((ImageDescriptor)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpub_obj.gif"), (int)1), methodSensorAssignment.isProtectedModifier() ? InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpro_obj.gif") : ImageDescriptor.createWithFlags((ImageDescriptor)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpro_obj.gif"), (int)1), methodSensorAssignment.isDefaultModifier() ? InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methdef_obj.gif") : ImageDescriptor.createWithFlags((ImageDescriptor)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methdef_obj.gif"), (int)1), methodSensorAssignment.isPrivateModifier() ? InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpri_obj.gif") : ImageDescriptor.createWithFlags((ImageDescriptor)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/methpri_obj.gif"), (int)1)};
        return ImageFormatter.getCombinedImage(resourceManager, 256, imageDescriptorArray);
    }

    public static Image getSensorAssignmentOptionsImage(ResourceManager resourceManager, AbstractClassSensorAssignment<?> abstractClassSensorAssignment) {
        ArrayList<ImageDescriptor> arrayList = new ArrayList<ImageDescriptor>();
        if (StringUtils.isNotEmpty((String)abstractClassSensorAssignment.getAnnotation())) {
            arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/annotation_obj.gif"));
        }
        if (abstractClassSensorAssignment instanceof TimerMethodSensorAssignment) {
            TimerMethodSensorAssignment timerMethodSensorAssignment = (TimerMethodSensorAssignment)abstractClassSensorAssignment;
            if (timerMethodSensorAssignment.isStartsInvocation()) {
                arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/fugue/arrow-switch.png"));
            }
            if (timerMethodSensorAssignment.isCharting()) {
                arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/graph_pie.gif"));
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (CollectionUtils.isNotEmpty((Collection)timerMethodSensorAssignment.getContextCaptures())) {
                for (AbstractContextCapture abstractContextCapture : timerMethodSensorAssignment.getContextCaptures()) {
                    bl |= abstractContextCapture instanceof ParameterContextCapture;
                    bl2 |= abstractContextCapture instanceof ReturnContextCapture;
                    bl3 |= abstractContextCapture instanceof FieldContextCapture;
                }
            }
            if (bl) {
                arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/selfmade/parameter.png"));
            }
            if (bl3) {
                arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/selfmade/field.png"));
            }
            if (bl2) {
                arrayList.add(InspectIT.getDefault().getImageDescriptor("/icons/selfmade/return.png"));
            }
        }
        if (CollectionUtils.isEmpty(arrayList)) {
            return null;
        }
        return ImageFormatter.getCombinedImage(resourceManager, 256, arrayList.toArray(new ImageDescriptor[arrayList.size()]));
    }

    public static Image getEnvironmentImage(Environment environment) {
        return InspectIT.getDefault().getImage("/icons/fugue/block.png");
    }

    public static Image getProfileImage(Profile profile) {
        if (profile.isCommonProfile()) {
            return InspectIT.getDefault().getImage("/icons/fugue/address-book-blue.png");
        }
        return InspectIT.getDefault().getImage("/icons/fugue/address-book.png");
    }
}

