/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.ColorFormatter;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.mutable.MutableDouble;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SqlInvocSummaryTextInputController
extends AbstractTextInputController {
    private static final String SLOWEST8020_COLOR = "slowest8020Color";
    private static final String SLOWEST80_LINK = "slowest80Link";
    private static final String SLOWEST20_LINK = "slowest20Link";
    private static final String SLOWEST_80_20 = "Slowest 80%/20%:";
    private static final String SQLS_DURATION_IN_INVOCATION = "SQLs duration in invocation:";
    private static final String TOTAL_DURATION = "Total duration:";
    private static final String TOTAL_SQLS = "Total SQLs:";
    private static final String RESET_LINK = "<a href=\"reset\">[RESET]</a>";
    private static final RGB GREEN_RGB;
    private static final RGB YELLOW_RGB;
    private static final RGB RED_RGB;
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Composite main;
    private FormText totalSql;
    private FormText totalDuration;
    private FormText percentageOfDuration;
    private FormText slowestCount;
    private HyperlinkSettings slowestHyperlinkSettings;
    private Collection<SqlStatementData> slowest80List = new ArrayList<SqlStatementData>();
    private Collection<SqlStatementData> slowest20List = new ArrayList<SqlStatementData>();
    private List<InvocationSequenceData> sourceInvocations;
    private String slowestContent;
    private boolean resetDisplayed;

    static {
        Display display = Display.getDefault();
        GREEN_RGB = display.getSystemColor(6).getRGB();
        YELLOW_RGB = display.getSystemColor(8).getRGB();
        RED_RGB = display.getSystemColor(3).getRGB();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.main = formToolkit.createComposite(composite, 2048);
        this.main.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(8, false);
        this.main.setLayout((Layout)gridLayout);
        formToolkit.createLabel(this.main, null).setImage(InspectIT.getDefault().getImage("/icons/fugue/database-sql.png"));
        this.totalSql = formToolkit.createFormText(this.main, false);
        this.totalSql.setToolTipText("Total amount of SQL Statements executed in the invocation");
        this.totalSql.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.createLabel(this.main, null).setImage(InspectIT.getDefault().getImage("/icons/eclipse/time.gif"));
        this.totalDuration = formToolkit.createFormText(this.main, false);
        this.totalDuration.setToolTipText("Duration sum of all SQL Statements executed in the invocation");
        this.totalDuration.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.createLabel(this.main, null).setImage(InspectIT.getDefault().getImage("/icons/fugue/arrow-switch.png"));
        this.percentageOfDuration = formToolkit.createFormText(this.main, false);
        this.percentageOfDuration.setToolTipText("Percentage of the time spent in the invocation on SQL Statements execution");
        this.percentageOfDuration.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.createLabel(this.main, null).setImage(InspectIT.getDefault().getImage("/icons/eclipse/help.gif"));
        this.slowestCount = formToolkit.createFormText(this.main, false);
        this.slowestCount.setLayoutData((Object)new GridData(4, 4, true, false));
        this.slowestCount.setToolTipText("Amount of slowest SQL Statements that take 80%/20% time of total SQL execution duration");
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).marginWidth = 0;
            ((GridLayout)layout).marginHeight = 0;
        }
        this.setDefaultText();
        this.slowestHyperlinkSettings = new HyperlinkSettings(composite.getDisplay());
        this.slowestHyperlinkSettings.setHyperlinkUnderlineMode(2);
        this.slowestCount.setHyperlinkSettings(this.slowestHyperlinkSettings);
        this.slowestCount.addHyperlinkListener((IHyperlinkListener)this.getHyperlinkAdapter());
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            DefaultData defaultData = list.get(0);
            if (defaultData instanceof InvocationSequenceData) {
                this.updateRepresentation(list);
            }
        } else {
            this.setDefaultText();
        }
    }

    private void updateRepresentation(List<InvocationSequenceData> list) {
        Object object;
        this.sourceInvocations = list;
        this.resetDisplayed = false;
        MutableDouble mutableDouble = new MutableDouble(0.0);
        ArrayList<SqlStatementData> arrayList = new ArrayList<SqlStatementData>();
        InvocationSequenceDataHelper.collectSqlsInInvocations(list, arrayList, (MutableDouble)mutableDouble);
        double d = 0.0;
        for (InvocationSequenceData invocationSequenceData : list) {
            d += invocationSequenceData.getDuration();
        }
        double d2 = mutableDouble.toDouble() / d * 100.0;
        this.slowest80List.clear();
        int n = this.getSlowestSqlCount(mutableDouble.toDouble(), arrayList, 0.8, this.slowest80List);
        int n2 = arrayList.size() - n;
        this.slowest20List = CollectionUtils.subtract(arrayList, this.slowest80List);
        this.totalSql.setText("<form><p><b>Total SQLs:</b> " + arrayList.size() + "</p></form>", true, false);
        this.totalDuration.setText("<form><p><b>Total duration:</b> " + NumberFormatter.formatDouble(mutableDouble.doubleValue()) + " ms</p></form>", true, false);
        String string = NumberFormatter.formatDouble(d2, 1);
        if (CollectionUtils.isNotEmpty(arrayList)) {
            object = ColorFormatter.getPerformanceColor(GREEN_RGB, YELLOW_RGB, RED_RGB, d2, 20.0, 80.0, this.resourceManager);
            this.percentageOfDuration.setColor("durationInInvocationColor", object);
            this.percentageOfDuration.setText("<form><p><b>SQLs duration in invocation:</b> <span color=\"durationInInvocationColor\">" + string + "%</span></p></form>", true, false);
        } else {
            this.percentageOfDuration.setText("<form><p><b>SQLs duration in invocation:</b> " + string + "%</p></form>", true, false);
        }
        object = this.getCountAndPercentage(n, arrayList.size());
        String string2 = this.getCountAndPercentage(n2, arrayList.size());
        if (CollectionUtils.isNotEmpty(arrayList)) {
            double d3 = (double)n / (double)arrayList.size() * 100.0;
            if (Double.isNaN(d3)) {
                d3 = 0.0;
            }
            Color color = ColorFormatter.getPerformanceColor(GREEN_RGB, YELLOW_RGB, RED_RGB, d3, 70.0, 10.0, this.resourceManager);
            this.slowestCount.setColor(SLOWEST8020_COLOR, color);
            this.slowestHyperlinkSettings.setForeground(color);
            StringBuilder stringBuilder = new StringBuilder("<b>Slowest 80%/20%:</b> ");
            if (n > 0) {
                stringBuilder.append("<a href=\"slowest80Link\">" + (String)object + "</a>");
            } else {
                stringBuilder.append("<span color=\"slowest8020Color\">" + (String)object + "</span>");
            }
            stringBuilder.append(" / ");
            if (n2 > 0) {
                stringBuilder.append("<a href=\"slowest20Link\">" + string2 + "</a>");
            } else {
                stringBuilder.append("<span color=\"slowest8020Color\">" + string2 + "</span>");
            }
            this.slowestContent = stringBuilder.toString();
        } else {
            this.slowestContent = "<b>Slowest 80%/20%:</b> " + (String)object + " / " + string2;
        }
        this.slowestCount.setText("<form><p>" + this.slowestContent + "</p></form>", true, false);
        this.main.layout();
    }

    private HyperlinkAdapter getHyperlinkAdapter() {
        return new HyperlinkAdapter(){

            public void linkActivated(final HyperlinkEvent hyperlinkEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                        IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                        if (SqlInvocSummaryTextInputController.SLOWEST80_LINK.equals(hyperlinkEvent.getHref())) {
                            iRootEditor.setDataInput(new ArrayList(SqlInvocSummaryTextInputController.this.slowest80List));
                            SqlInvocSummaryTextInputController.this.showResetFor8020(true);
                        } else if (SqlInvocSummaryTextInputController.SLOWEST20_LINK.equals(hyperlinkEvent.getHref())) {
                            iRootEditor.setDataInput(new ArrayList(SqlInvocSummaryTextInputController.this.slowest20List));
                            SqlInvocSummaryTextInputController.this.showResetFor8020(true);
                        } else {
                            iRootEditor.setDataInput(SqlInvocSummaryTextInputController.this.sourceInvocations);
                            SqlInvocSummaryTextInputController.this.showResetFor8020(false);
                        }
                    }
                });
            }
        };
    }

    private void showResetFor8020(boolean bl) {
        if (bl && !this.resetDisplayed) {
            this.resetDisplayed = true;
            this.slowestCount.setText("<form><p>" + this.slowestContent + " " + RESET_LINK + "</p></form>", true, false);
        } else if (!bl && this.resetDisplayed) {
            this.resetDisplayed = false;
            this.slowestCount.setText("<form><p>" + this.slowestContent + "</p></form>", true, false);
        }
    }

    private void setDefaultText() {
        this.resetDisplayed = false;
        this.totalSql.setText("<form><p><b>Total SQLs:</b></p></form>", true, false);
        this.totalDuration.setText("<form><p><b>Total duration:</b></p></form>", true, false);
        this.percentageOfDuration.setText("<form><p><b>SQLs duration in invocation:</b></p></form>", true, false);
        this.slowestCount.setText("<form><p><b>Slowest 80%/20%:</b></p></form>", true, false);
    }

    private String getCountAndPercentage(int n, int n2) {
        if (n2 == 0) {
            return "0(0%)";
        }
        return String.valueOf(n) + "(" + NumberFormatter.formatDouble((double)n / (double)n2 * 100.0, 0) + "%)";
    }

    private int getSlowestSqlCount(double d, List<SqlStatementData> list, double d2, Collection<SqlStatementData> collection) {
        Collections.sort(list, new Comparator<SqlStatementData>(){

            @Override
            public int compare(SqlStatementData sqlStatementData, SqlStatementData sqlStatementData2) {
                return ObjectUtils.compare((Comparable)Double.valueOf(sqlStatementData2.getDuration()), (Object)sqlStatementData.getDuration());
            }
        });
        int n = 0;
        double d3 = 0.0;
        for (SqlStatementData sqlStatementData : list) {
            if (!(d3 / d < d2)) break;
            ++n;
            collection.add(sqlStatementData);
            d3 += sqlStatementData.getDuration();
        }
        return n;
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

