/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MemoryInputController
extends AbstractTextInputController {
    public static final String ID = "inspectit.subview.text.memory";
    private static final String SECTION_MEMORY = "Memory";
    private static final String NOT_AVAILABLE = "N/A";
    private MemoryInformationData memoryObj;
    private SystemInformationData systemObj;
    private Label freePhysMemory;
    private Label freeSwapSpace;
    private Label committedHeapMemorySize;
    private Label committedNonHeapMemorySize;
    private Label usedHeapMemorySize;
    private Label usedNonHeapMemorySize;
    private IGlobalDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.memoryObj = new MemoryInformationData();
        this.memoryObj.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.systemObj = new SystemInformationData();
        this.systemObj.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.addSection(composite, formToolkit, SECTION_MEMORY);
        SystemInformationData systemInformationData = (SystemInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.systemObj);
        if (systemInformationData != null) {
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max heap size: ");
            if (systemInformationData.getMaxHeapMemorySize() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getMaxHeapMemorySize()));
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max non-heap size: ");
            if (systemInformationData.getMaxNonHeapMemorySize() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getMaxNonHeapMemorySize()));
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total physical memory: ");
            if (systemInformationData.getTotalPhysMemory() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getTotalPhysMemory()));
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total swap space: ");
            if (systemInformationData.getTotalSwapSpace() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getTotalSwapSpace()));
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            }
        } else {
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max heap size: ");
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max non-heap size: ");
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total physical memory: ");
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total swap space: ");
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE);
        }
        if (this.sections.containsKey(SECTION_MEMORY)) {
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Free physical memory: ");
            this.freePhysMemory = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.freePhysMemory.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Free swap space: ");
            this.freeSwapSpace = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.freeSwapSpace.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Committed heap size: ");
            this.committedHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.committedHeapMemorySize.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Committed non-heap size: ");
            this.committedNonHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.committedNonHeapMemorySize.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Used heap size: ");
            this.usedHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.usedHeapMemorySize.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Used non-heap size: ");
            this.usedNonHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, 16384);
            this.usedNonHeapMemorySize.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        final MemoryInformationData memoryInformationData = (MemoryInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.memoryObj);
        if (memoryInformationData != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int n = memoryInformationData.getCount();
                    if (memoryInformationData.getTotalFreePhysMemory() > 0L) {
                        MemoryInputController.this.freePhysMemory.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalFreePhysMemory() / (long)n));
                    } else {
                        MemoryInputController.this.freePhysMemory.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalFreeSwapSpace() > 0L) {
                        MemoryInputController.this.freeSwapSpace.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalFreeSwapSpace() / (long)n));
                    } else {
                        MemoryInputController.this.freeSwapSpace.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalComittedHeapMemorySize() > 0L) {
                        MemoryInputController.this.committedHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalComittedHeapMemorySize() / (long)n));
                    } else {
                        MemoryInputController.this.committedHeapMemorySize.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalComittedNonHeapMemorySize() > 0L) {
                        MemoryInputController.this.committedNonHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalComittedNonHeapMemorySize() / (long)n));
                    } else {
                        MemoryInputController.this.committedNonHeapMemorySize.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalUsedHeapMemorySize() > 0L) {
                        MemoryInputController.this.usedHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalUsedHeapMemorySize() / (long)n));
                    } else {
                        MemoryInputController.this.usedHeapMemorySize.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalUsedNonHeapMemorySize() > 0L) {
                        MemoryInputController.this.usedNonHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalUsedNonHeapMemorySize() / (long)n));
                    } else {
                        MemoryInputController.this.usedNonHeapMemorySize.setText(MemoryInputController.NOT_AVAILABLE);
                    }
                }
            });
        }
    }

    @Override
    public void dispose() {
    }
}

