/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ClassLoadingInformationData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ClassesInputController
extends AbstractTextInputController {
    public static final String ID = "inspectit.subview.text.classes";
    private static final String SECTION_CLASSES = "Classes";
    private ClassLoadingInformationData classLoadingObj;
    private Label loadedClassCount;
    private Label totalLoadedClassCount;
    private Label unloadedClassCount;
    private IGlobalDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.classLoadingObj = new ClassLoadingInformationData();
        this.classLoadingObj.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.addSection(composite, formToolkit, SECTION_CLASSES);
        if (this.sections.containsKey(SECTION_CLASSES)) {
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Current loaded classes: ");
            this.loadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), "n/a");
            this.loadedClassCount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Total loaded classes: ");
            this.totalLoadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), "n/a");
            this.totalLoadedClassCount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Total unloaded classes: ");
            this.unloadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), "n/a");
            this.unloadedClassCount.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        final ClassLoadingInformationData classLoadingInformationData = (ClassLoadingInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.classLoadingObj);
        if (classLoadingInformationData != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int n = classLoadingInformationData.getCount();
                    ClassesInputController.this.loadedClassCount.setText(NumberFormatter.formatInteger(classLoadingInformationData.getTotalLoadedClassCount() / n));
                    ClassesInputController.this.totalLoadedClassCount.setText(NumberFormatter.formatLong(classLoadingInformationData.getTotalTotalLoadedClassCount() / (long)n));
                    ClassesInputController.this.unloadedClassCount.setText(NumberFormatter.formatLong(classLoadingInformationData.getTotalUnloadedClassCount() / (long)n));
                }
            });
        }
    }

    @Override
    public void dispose() {
    }
}

