/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.testers;

import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.communication.data.AggregatedTimerData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class NavigationTester
extends PropertyTester {
    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        if ("canNavigateToPlotting".equals(string)) {
            if (object instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)object;
                Object object3 = structuredSelection.getFirstElement();
                if (object3 instanceof InvocationSequenceData) {
                    TimerData timerData = ((InvocationSequenceData)object3).getTimerData();
                    return this.isTimerSensorBounded(timerData) && timerData.isCharting();
                }
                if (object3 instanceof TimerData) {
                    return this.isTimerSensorBounded((TimerData)object3) && ((TimerData)object3).isCharting();
                }
            }
        } else if ("canNavigateToInvocations".equals(string)) {
            if (object instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)object;
                for (Object e : structuredSelection) {
                    InvocationAwareData invocationAwareData;
                    if (!(e instanceof InvocationAwareData) || (invocationAwareData = (InvocationAwareData)e).isOnlyFoundOutsideInvocations()) continue;
                    return true;
                }
            }
        } else if ("canNavigateToExceptionType".equals(string)) {
            StructuredSelection structuredSelection = (StructuredSelection)object;
            Object object4 = structuredSelection.getFirstElement();
            if (object4 instanceof InvocationSequenceData) {
                List list = ((InvocationSequenceData)object4).getExceptionSensorDataObjects();
                if (list != null && !list.isEmpty()) {
                    for (ExceptionSensorData exceptionSensorData : list) {
                        if (exceptionSensorData.getThrowableType() == null) continue;
                        return true;
                    }
                }
            } else if (object4 instanceof ExceptionSensorData) {
                return ((ExceptionSensorData)object4).getThrowableType() != null;
            }
        } else if ("canNavigateToAggregatedTimerData".equals(string)) {
            if (object instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)object;
                Object object5 = structuredSelection.getFirstElement();
                if (object5 instanceof InvocationSequenceData) {
                    TimerData timerData = ((InvocationSequenceData)object5).getTimerData();
                    return this.isTimerSensorBounded(timerData);
                }
                if (object5 instanceof TimerData) {
                    return this.isTimerSensorBounded((TimerData)object5);
                }
            }
        } else if ("canNavigateToAggregatedSqlData".equals(string) && object instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)object;
            Object object6 = structuredSelection.getFirstElement();
            if (object6 instanceof InvocationSequenceData) {
                return ((InvocationSequenceData)object6).getSqlStatementData() != null;
            }
            if (object6 instanceof SqlStatementData) {
                return true;
            }
        }
        return false;
    }

    private boolean isTimerSensorBounded(TimerData timerData) {
        RepositoryDefinition repositoryDefinition;
        SensorTypeIdent sensorTypeIdent;
        if (timerData == null || !timerData.getClass().equals(TimerData.class) && !timerData.getClass().equals(AggregatedTimerData.class)) {
            return false;
        }
        IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (iEditorPart instanceof AbstractRootEditor && (sensorTypeIdent = (repositoryDefinition = ((AbstractRootEditor)iEditorPart).getInputDefinition().getRepositoryDefinition()).getCachedDataService().getSensorTypeIdentForId(timerData.getSensorTypeIdent())) != null) {
            SensorTypeEnum sensorTypeEnum = SensorTypeEnum.get(sensorTypeIdent.getFullyQualifiedClassName());
            return sensorTypeEnum == SensorTypeEnum.TIMER || sensorTypeEnum == SensorTypeEnum.AVERAGE_TIMER;
        }
        return false;
    }
}

