/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.comparator.HttpTimerDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractHttpInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;

public class TaggedHttpTimerDataInputController
extends AbstractHttpInputController {
    public static final String ID = "inspectit.subview.table.taggedhttptimerdata";

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Getting HTTP data information", -1);
        List list = this.autoUpdate ? this.httptimerDataAccessService.getTaggedAggregatedTimerData(this.template, this.httpCatorizationOnRequestMethodActive) : this.httptimerDataAccessService.getTaggedAggregatedTimerData(this.template, this.httpCatorizationOnRequestMethodActive, this.fromDate, this.toDate);
        this.timerDataList.clear();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.timerDataList.addAll(list);
        }
        iProgressMonitor.done();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new StyledCellIndexLabelProvider(){

            @Override
            public StyledString getStyledText(Object object, int n) {
                HttpTimerData httpTimerData = (HttpTimerData)object;
                Column column = Column.fromOrd(n);
                StyledString styledString = TaggedHttpTimerDataInputController.this.getStyledTextForColumn(httpTimerData, column);
                if (this.addWarnSign((TimerData)httpTimerData, column)) {
                    styledString.append(TextFormatter.getWarningSign());
                }
                return styledString;
            }

            private boolean addWarnSign(TimerData timerData, Column column) {
                switch (column) {
                    case EXCLUSIVEAVERAGE: 
                    case EXCLUSIVEMIN: 
                    case EXCLUSIVEMAX: 
                    case EXCLUSIVESUM: {
                        int n = (int)(timerData.getInvocationAffiliationPercentage() * 100.0);
                        return timerData.isExclusiveTimeDataAvailable() && n < 100;
                    }
                }
                return false;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                HttpTimerData httpTimerData = (HttpTimerData)object;
                Column column = Column.fromOrd(n);
                switch (column) {
                    case CHARTING: {
                        if (!httpTimerData.isCharting()) break;
                        return InspectIT.getDefault().getImage("/icons/eclipse/graph_pie.gif");
                    }
                }
                return super.getColumnImage(object, n);
            }

            @Override
            public String getToolTipText(Object object, int n) {
                HttpTimerData httpTimerData = (HttpTimerData)object;
                Column column = Column.fromOrd(n);
                switch (column) {
                    case CHARTING: {
                        if (!httpTimerData.isCharting()) break;
                        return "Duration chart can be displayed for this HTTP data.";
                    }
                }
                return super.getToolTipText(object, n);
            }
        };
    }

    @Override
    public ViewerComparator getComparator() {
        ICachedDataService iCachedDataService = this.getInputDefinition().getRepositoryDefinition().getCachedDataService();
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, iCachedDataService);
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof HttpTimerData) {
            HttpTimerData httpTimerData = (HttpTimerData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(httpTimerData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof HttpTimerData) {
            HttpTimerData httpTimerData = (HttpTimerData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(httpTimerData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    private StyledString getStyledTextForColumn(HttpTimerData httpTimerData, Column column) {
        switch (column) {
            case CHARTING: {
                return this.emptyStyledString;
            }
            case TAG_VALUE: {
                return new StyledString(httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue());
            }
            case HTTP_METHOD: {
                return new StyledString(httpTimerData.getHttpInfo().getRequestMethod());
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(httpTimerData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (httpTimerData.getInvocationParentsIdSet() != null) {
                    n2 = httpTimerData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
            case COUNT: {
                return new StyledString(String.valueOf(httpTimerData.getCount()));
            }
            case AVERAGE: {
                if (httpTimerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case MIN: {
                if (httpTimerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case MAX: {
                if (httpTimerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case DURATION: {
                if (httpTimerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUAVERAGE: {
                if (httpTimerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getCpuAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUMIN: {
                if (httpTimerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getCpuMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUMAX: {
                if (httpTimerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getCpuMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUDURATION: {
                if (httpTimerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getCpuDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEAVERAGE: {
                if (httpTimerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getExclusiveAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMAX: {
                if (httpTimerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getExclusiveMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMIN: {
                if (httpTimerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getExclusiveMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVESUM: {
                if (httpTimerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(httpTimerData.getExclusiveDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    private static enum Column {
        CHARTING("Charting", 20, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.CHARTING),
        TAG_VALUE("Tag Value", 300, "/icons/eclipse/gel_sc_obj.gif", (IDataComparator<? super HttpTimerData>)HttpTimerDataComparatorEnum.TAG_VALUE),
        HTTP_METHOD("Method", 80, null, (IDataComparator<? super HttpTimerData>)HttpTimerDataComparatorEnum.HTTP_METHOD),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super HttpTimerData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION),
        COUNT("Count", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 70, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.DURATION),
        EXCLUSIVEAVERAGE("Exc. Avg (ms)", 80, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.EXCLUSIVEAVERAGE),
        EXCLUSIVEMIN("Exc. Min (ms)", 80, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.EXCLUSIVEMIN),
        EXCLUSIVEMAX("Exc. Max (ms)", 80, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.EXCLUSIVEMAX),
        EXCLUSIVESUM("Exc. duration (ms)", 80, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.EXCLUSIVEDURATION),
        CPUAVERAGE("Cpu Avg (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.CPUAVERAGE),
        CPUMIN("Cpu Min (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.CPUMIN),
        CPUMAX("Cpu Max (ms)", 60, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.CPUMAX),
        CPUDURATION("Cpu Duration (ms)", 70, null, (IDataComparator<? super HttpTimerData>)TimerDataComparatorEnum.CPUDURATION);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super HttpTimerData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super HttpTimerData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }
}

