/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.comparator.SqlStatementDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.text.input.SqlStatementTextInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SqlParameterAggregationInputControler
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.sqlparameteraggregation";
    private int timeDecimalPlaces = PreferencesUtils.getIntValue("DECIMAL_PLACES");

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
        }
        enumSet.add(PreferenceId.TIME_RESOLUTION);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIME_RESOLUTION: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID)) break;
                this.timeDecimalPlaces = (Integer)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID);
                break;
            }
        }
    }

    @Override
    public Object getTableInput() {
        return null;
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list != null) {
            for (DefaultData defaultData : list) {
                if (!(defaultData instanceof SqlStatementTextInputController.SqlHolderHelper)) {
                    return false;
                }
                if (((SqlStatementTextInputController.SqlHolderHelper)defaultData).isMaster()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new SqlParameterContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new SqlLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        ICachedDataService iCachedDataService = this.getInputDefinition().getRepositoryDefinition().getCachedDataService();
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, iCachedDataService);
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(sqlStatementData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        if (object != null) {
            ArrayList<SqlStatementData> arrayList = new ArrayList<SqlStatementData>();
            List list = (List)object;
            for (SqlStatementTextInputController.SqlHolderHelper sqlHolderHelper : list) {
                arrayList.addAll(sqlHolderHelper.getSqlStatementDataList());
            }
            return arrayList.toArray(new SqlStatementData[arrayList.size()]);
        }
        return new Object[0];
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(sqlStatementData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        Object object;
        StructuredSelection structuredSelection = (StructuredSelection)doubleClickEvent.getSelection();
        if (!structuredSelection.isEmpty() && (object = structuredSelection.getFirstElement()) instanceof SqlStatementData) {
            ArrayList<SqlStatementData> arrayList = new ArrayList<SqlStatementData>();
            arrayList.add((SqlStatementData)object);
            this.passSqlWithParameters(arrayList);
        }
    }

    private StyledString getStyledTextForColumn(SqlStatementData sqlStatementData, Column column) {
        switch (column) {
            case PARAMETERS: {
                return new StyledString(TextFormatter.getSqlParametersText(sqlStatementData.getParameterValues()));
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(sqlStatementData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (sqlStatementData.getInvocationParentsIdSet() != null) {
                    n2 = sqlStatementData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
            case COUNT: {
                return new StyledString(Long.toString(sqlStatementData.getCount()));
            }
            case AVERAGE: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getAverage(), this.timeDecimalPlaces));
            }
            case MIN: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMin(), this.timeDecimalPlaces));
            }
            case MAX: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMax(), this.timeDecimalPlaces));
            }
            case DURATION: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getDuration(), this.timeDecimalPlaces));
            }
        }
        return new StyledString("error");
    }

    private void passSqlWithParameters(List<SqlStatementData> list) {
        final SqlStatementTextInputController.SqlHolderHelper sqlHolderHelper = new SqlStatementTextInputController.SqlHolderHelper(list, false);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                if (iRootEditor != null) {
                    iRootEditor.setDataInput(Collections.singletonList(sqlHolderHelper));
                }
            }
        });
    }

    private static enum Column {
        PARAMETERS("Parameters", 600, null, (IDataComparator<? super SqlStatementData>)SqlStatementDataComparatorEnum.PARAMETERS),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super SqlStatementData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION),
        COUNT("Count", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.DURATION);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super SqlStatementData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super SqlStatementData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class SqlLabelProvider
    extends StyledCellIndexLabelProvider {
        private SqlLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            Column column = Column.fromOrd(n);
            return SqlParameterAggregationInputControler.this.getStyledTextForColumn(sqlStatementData, column);
        }
    }

    private final class SqlParameterContentProvider
    implements IStructuredContentProvider {
        private SqlParameterContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 == null || Objects.equals(object2, Collections.emptyList())) {
                viewer.getControl().setEnabled(false);
            } else {
                List list = (List)object2;
                List<SqlStatementData> list2 = ((SqlStatementTextInputController.SqlHolderHelper)((Object)list.get(0))).getSqlStatementDataList();
                if (list2 == null || Objects.equals(list2, Collections.emptyList())) {
                    viewer.getControl().setEnabled(false);
                } else {
                    viewer.getControl().setEnabled(true);
                    SqlParameterAggregationInputControler.this.passSqlWithParameters(list2);
                    StructuredSelection structuredSelection = new StructuredSelection((Object)list2.get(0));
                    viewer.setSelection((ISelection)structuredSelection, true);
                }
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object e;
            if (object instanceof List && !((List)object).isEmpty() && (e = ((List)object).get(0)) instanceof SqlStatementTextInputController.SqlHolderHelper) {
                return ((SqlStatementTextInputController.SqlHolderHelper)((Object)e)).getSqlStatementDataList().toArray();
            }
            return new Object[0];
        }
    }
}

