/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.AbstractSubView;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchCriteria;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchResult;
import info.novatec.inspectit.rcp.editor.search.helper.TableViewerSearchHelper;
import info.novatec.inspectit.rcp.editor.table.input.TableInputController;
import info.novatec.inspectit.rcp.editor.tooltip.ColumnAwareToolTipSupport;
import info.novatec.inspectit.rcp.editor.tooltip.IColumnToolTipProvider;
import info.novatec.inspectit.rcp.editor.viewers.CheckedDelegatingIndexLabelProvider;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.handlers.ShowHideColumnsHandler;
import info.novatec.inspectit.rcp.menu.ShowHideMenuManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TableSubView
extends AbstractSubView
implements ISearchExecutor {
    private final TableInputController tableInputController;
    private TableViewer tableViewer;
    private volatile boolean jobInSchedule = false;
    private TableViewerSearchHelper tableViewerSearchHelper;

    public TableSubView(TableInputController tableInputController) {
        Assert.isNotNull((Object)tableInputController);
        this.tableInputController = tableInputController;
    }

    @Override
    public void init() {
        this.tableInputController.setInputDefinition(this.getRootEditor().getInputDefinition());
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        Object object;
        MenuManager menuManager;
        Object object2;
        Object object3;
        Object object4;
        int n = 68354;
        n = this.tableInputController.isCheckStyle() ? (n |= 0x20) : (n |= 0x10000000);
        final Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        if (this.tableInputController.isCheckStyle()) {
            object4 = new TableViewerColumn(this.tableViewer, 0);
            object4.getColumn().setMoveable(false);
            object4.getColumn().setResizable(true);
            object4.getColumn().setWidth(30);
            object4.getColumn().setText("Selected");
        }
        this.tableInputController.createColumns(this.tableViewer);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider(this.tableInputController.getContentProvider());
        object4 = this.tableInputController.getLabelProvider();
        if (this.tableInputController.isCheckStyle() && object4 instanceof StyledCellIndexLabelProvider) {
            object4 = new CheckedDelegatingIndexLabelProvider((StyledCellIndexLabelProvider)object4);
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)object4);
        if (object4 instanceof IColumnToolTipProvider) {
            ColumnAwareToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        }
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                TableSubView.this.tableInputController.doubleClick(doubleClickEvent);
            }
        });
        this.tableViewer.setComparator(this.tableInputController.getComparator());
        if (this.tableViewer.getComparator() != null) {
            object2 = object3 = this.tableViewer.getTable().getColumns();
            int n2 = ((TableColumn[])object3).length;
            int n3 = 0;
            while (n3 < n2) {
                menuManager = object2[n3];
                menuManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TableSubView.this.tableViewer.refresh();
                    }
                });
                ++n3;
            }
        }
        object3 = new ShowHideMenuManager((ColumnViewer)this.tableViewer, this.tableInputController.getClass());
        object3.setRemoveAllWhenShown(false);
        menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.getRootEditor().getSite().registerContextMenu("inspectit.editor.formrooteditor.tablesubview", menuManager, (ISelectionProvider)this.tableViewer);
        final Menu menu = menuManager.createContextMenu((Control)table);
        final Menu menu2 = object3.createContextMenu((Control)table);
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean bl;
                Point point = Display.getDefault().map(null, (Control)table, new Point(event.x, event.y));
                Rectangle rectangle = table.getClientArea();
                boolean bl2 = bl = rectangle.y <= point.y && point.y < rectangle.y + table.getHeaderHeight();
                if (bl) {
                    table.setMenu(menu2);
                } else {
                    table.setMenu(menu);
                }
            }
        });
        table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!menu2.isDisposed()) {
                    menu2.dispose();
                }
                if (!menu.isDisposed()) {
                    menu.dispose();
                }
            }
        });
        object2 = this.tableInputController.getTableInput();
        this.tableViewer.setInput(object2);
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TableColumn tableColumn;
                if (controlEvent.widget instanceof TableColumn && (tableColumn = (TableColumn)controlEvent.widget).getWidth() > 0) {
                    ShowHideColumnsHandler.registerNewColumnWidth(TableSubView.this.tableInputController.getClass(), tableColumn.getText(), tableColumn.getWidth());
                }
            }

            public void controlMoved(ControlEvent controlEvent) {
                ShowHideColumnsHandler.setColumnOrder(TableSubView.this.tableInputController.getClass(), TableSubView.this.tableViewer.getTable().getColumnOrder());
            }
        };
        TableColumn[] tableColumnArray = table.getColumns();
        int n4 = tableColumnArray.length;
        int n5 = 0;
        while (n5 < n4) {
            object = tableColumnArray[n5];
            if (this.tableInputController.canAlterColumnWidth((TableColumn)object)) {
                Integer n6 = ShowHideColumnsHandler.getRememberedColumnWidth(this.tableInputController.getClass(), object.getText());
                boolean bl = ShowHideColumnsHandler.isColumnHidden(this.tableInputController.getClass(), object.getText());
                if (n6 != null && !bl) {
                    object.setWidth(n6.intValue());
                    object.setResizable(true);
                } else if (bl) {
                    object.setWidth(0);
                    object.setResizable(false);
                }
            }
            object.addControlListener((ControlListener)controlAdapter);
            ++n5;
        }
        object = ShowHideColumnsHandler.getColumnOrder(this.tableInputController.getClass());
        if (object != null && ((TableColumn)object).length == table.getColumns().length) {
            table.setColumnOrder((int[])object);
        } else if (object != null) {
            ShowHideColumnsHandler.setColumnOrder(this.tableInputController.getClass(), table.getColumnOrder());
        }
        this.tableViewerSearchHelper = new TableViewerSearchHelper(this.tableViewer, this.tableInputController, this.getRootEditor().getInputDefinition().getRepositoryDefinition());
        if (this.tableInputController.isCheckStyle()) {
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.detail == 32 && selectionEvent.item instanceof TableItem) {
                        TableItem tableItem = (TableItem)selectionEvent.item;
                        TableSubView.this.tableInputController.objectChecked(tableItem.getData(), tableItem.getChecked());
                    }
                }
            });
        }
    }

    @Override
    public void doRefresh() {
        if (!this.jobInSchedule) {
            this.jobInSchedule = true;
            Job job = new Job(this.getDataLoadingJobName()){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            TableSubView.this.tableInputController.doRefresh(iProgressMonitor, TableSubView.this.getRootEditor());
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (TableSubView.this.checkDisposed()) {
                                        return;
                                    }
                                    if (TableSubView.this.tableInputController.getSubViewClassification() == SubViewClassificationController.SubViewClassification.MASTER) {
                                        Object object = TableSubView.this.tableInputController.getTableInput();
                                        TableSubView.this.tableViewer.setInput(object);
                                        if (TableSubView.this.tableViewer.getTable().isVisible()) {
                                            TableSubView.this.tableViewer.refresh();
                                            if (TableSubView.this.tableInputController.isCheckStyle()) {
                                                TableItem[] tableItemArray = TableSubView.this.tableViewer.getTable().getItems();
                                                int n = tableItemArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    TableItem tableItem = tableItemArray[n2];
                                                    tableItem.setChecked(TableSubView.this.tableInputController.areItemsInitiallyChecked());
                                                    ++n2;
                                                }
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException("Unknown exception occurred trying to refresh the view.", throwable);
                        }
                    }
                    finally {
                        TableSubView.this.jobInSchedule = false;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.tableInputController.canOpenInput(list)) {
            this.tableViewer.setInput(list);
            this.tableViewer.refresh(true);
        }
    }

    @Override
    public Control getControl() {
        return this.tableViewer.getControl();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.tableViewer;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        return this.tableInputController.getPreferenceIds();
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        if (this.checkDisposed()) {
            return;
        }
        if (PreferenceId.ITEMCOUNT.equals((Object)preferenceEvent.getPreferenceId())) {
            Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
            int n = (Integer)map.get(PreferenceId.ItemCount.COUNT_SELECTION_ID);
            this.tableInputController.setLimit(n);
            this.doRefresh();
        }
        this.tableViewer.getTable().setRedraw(false);
        this.tableInputController.preferenceEventFired(preferenceEvent);
        this.tableViewer.getTable().setRedraw(true);
        switch (preferenceEvent.getPreferenceId()) {
            case CLEAR_BUFFER: {
                if (!this.tableInputController.getPreferenceIds().contains((Object)PreferenceId.CLEAR_BUFFER)) break;
                this.tableViewer.refresh();
                break;
            }
            case TIME_RESOLUTION: {
                if (!this.tableInputController.getPreferenceIds().contains((Object)PreferenceId.TIME_RESOLUTION)) break;
                this.tableViewer.refresh();
                break;
            }
            case INVOCATION_SUBVIEW_MODE: {
                if (!this.tableInputController.getPreferenceIds().contains((Object)PreferenceId.INVOCATION_SUBVIEW_MODE)) break;
                this.tableViewer.refresh();
                break;
            }
        }
    }

    public TableInputController getTableInputController() {
        return this.tableInputController;
    }

    public List<String> getColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            arrayList.add(tableColumn.getText());
            ++n2;
        }
        return arrayList;
    }

    public List<Integer> getColumnOrder() {
        int[] nArray = this.tableViewer.getTable().getColumnOrder();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (this.tableViewer.getTable().getColumns()[n3].getWidth() > 0) {
                arrayList.add(n3);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public ISubView getSubViewWithInputController(Class<?> clazz) {
        if (Objects.equals(clazz, this.tableInputController.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public SearchResult executeSearch(SearchCriteria searchCriteria) {
        return this.tableViewerSearchHelper.executeSearch(searchCriteria);
    }

    @Override
    public SearchResult next() {
        return this.tableViewerSearchHelper.next();
    }

    @Override
    public SearchResult previous() {
        return this.tableViewerSearchHelper.previous();
    }

    @Override
    public void clearSearch() {
        this.tableViewerSearchHelper.clearSearch();
    }

    private boolean checkDisposed() {
        return this.tableViewer.getTable().isDisposed();
    }

    @Override
    public void dispose() {
        this.tableInputController.dispose();
    }
}

