/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.AbstractViewerComparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class RemoteTableViewerComparator<T extends DefaultData>
extends AbstractViewerComparator<T> {
    public final void addColumn(final TableColumn tableColumn, final ResultComparator<T> resultComparator) {
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RemoteTableViewerComparator.this.toggleSortColumn(resultComparator);
                final AbstractViewerComparator.SortState sortState = RemoteTableViewerComparator.this.getSortState();
                Table table = tableColumn.getParent();
                table.setSortColumn(tableColumn);
                table.setSortDirection(sortState.getSwtDirection());
                try {
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (sortState != AbstractViewerComparator.SortState.NONE) {
                                RemoteTableViewerComparator.this.sortRemotely(resultComparator);
                            } else {
                                RemoteTableViewerComparator.this.sortRemotely(null);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    InspectIT.getDefault().createErrorDialog("Exception occurred trying to remotely sort on the selected column.", exception, -1);
                }
            }
        });
    }

    protected abstract void sortRemotely(ResultComparator<T> var1);

    @Override
    public int compare(Viewer viewer, Object object, Object object2) {
        return 0;
    }
}

