/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.preferences.control;

import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.IPreferencePanel;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.preferences.control.AbstractPreferenceControl;
import info.novatec.inspectit.rcp.editor.preferences.control.IPreferenceControl;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SamplingRateControl
extends AbstractPreferenceControl
implements IPreferenceControl {
    private static final PreferenceId CONTROL_GROUP_ID = PreferenceId.SAMPLINGRATE;
    private Scale slider = null;
    private Button timeframeModeButton = null;
    public static final Sensitivity DEFAULT_SENSITIVITY = Sensitivity.MEDIUM;

    public SamplingRateControl(IPreferencePanel iPreferencePanel) {
        super(iPreferencePanel);
    }

    @Override
    public Composite createControls(Composite composite, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(composite, 256);
        section.setText("Sampling Rate");
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite2);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginLeft = 10;
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1024, -1);
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        final Label label = formToolkit.createLabel(composite2, "no sensitivity selected", 16384);
        GridData gridData2 = new GridData(4, 4, false, false);
        gridData2.widthHint = label.computeSize((int)-1, (int)-1).x;
        label.setLayoutData((Object)gridData2);
        this.slider = new Scale(composite2, 256);
        formToolkit.adapt((Control)this.slider, true, true);
        this.slider.setMinimum(0);
        this.slider.setMaximum(Sensitivity.values().length - 1);
        this.slider.setIncrement(1);
        this.slider.setSize(200, 10);
        this.slider.setLayoutData((Object)new GridData(4, 4, true, false));
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Sensitivity sensitivity = Sensitivity.fromOrd(SamplingRateControl.this.slider.getSelection());
                switch (sensitivity) {
                    case NO_SENSITIVITY: {
                        label.setText("no sensitivity selected");
                        break;
                    }
                    case VERY_FINE: {
                        label.setText("very fine");
                        break;
                    }
                    case FINE: {
                        label.setText("fine");
                        break;
                    }
                    case MEDIUM: {
                        label.setText("medium");
                        break;
                    }
                    case COARSE: {
                        label.setText("coarse");
                        break;
                    }
                    case VERY_COARSE: {
                        label.setText("very coarse");
                        break;
                    }
                }
            }
        });
        this.slider.setSelection(DEFAULT_SENSITIVITY.ordinal());
        this.slider.notifyListeners(13, null);
        Label label2 = formToolkit.createLabel(composite2, "Sampling Rate Mode: ", 16384);
        label2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.timeframeModeButton = formToolkit.createButton(composite2, "Timeframe dividing", 16);
        this.timeframeModeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.timeframeModeButton.setSelection(true);
        return composite2;
    }

    @Override
    public Map<IPreferenceGroup, Object> eventFired() {
        Sensitivity sensitivity = Sensitivity.fromOrd(this.slider.getSelection());
        HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
        hashMap.put(PreferenceId.SamplingRate.SLIDER_ID, (Object)sensitivity);
        if (this.timeframeModeButton.getSelection()) {
            hashMap.put(PreferenceId.SamplingRate.DIVIDER_ID, PreferenceId.SamplingRate.TIMEFRAME_DIVIDER_ID);
        }
        return hashMap;
    }

    @Override
    public PreferenceId getControlGroupId() {
        return CONTROL_GROUP_ID;
    }

    @Override
    public void dispose() {
    }

    public static enum Sensitivity {
        NO_SENSITIVITY(0),
        VERY_FINE(200),
        FINE(120),
        MEDIUM(75),
        COARSE(30),
        VERY_COARSE(15);

        private int value;

        private Sensitivity(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static Sensitivity fromOrd(int n) {
            if (n < 0 || n >= Sensitivity.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Sensitivity.values()[n];
        }
    }
}

