/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.composite;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.composite.AbstractCompositeSubView;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TabbedCompositeSubView
extends AbstractCompositeSubView {
    private CTabFolder tabFolder;
    private Map<ISubView, String> tabNames = new HashMap<ISubView, String>();
    private Map<ISubView, Image> tabImageMap = new HashMap<ISubView, Image>();

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.tabFolder = new CTabFolder(composite, 0x800700);
        this.tabFolder.setBorderVisible(true);
        for (final ISubView iSubView : this.getSubViews()) {
            iSubView.createPartControl((Composite)this.tabFolder, formToolkit);
            CTabItem cTabItem = new CTabItem(this.tabFolder, 0, this.getPageCount());
            cTabItem.setControl(iSubView.getControl());
            cTabItem.setText(this.tabNames.get(iSubView));
            cTabItem.setImage(this.tabImageMap.get(iSubView));
            iSubView.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    TabbedCompositeSubView.this.getRootEditor().setActiveSubView(iSubView);
                }
            });
            if (iSubView.getSelectionProvider() == null) continue;
            ISelectionProvider iSelectionProvider = iSubView.getSelectionProvider();
            iSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    TabbedCompositeSubView.this.getRootEditor().setSelection(selectionChangedEvent.getSelection());
                }
            });
            iSelectionProvider.addSelectionChangedListener(this.getRootEditor().getSelectionChangedListener());
            if (!(iSelectionProvider instanceof IPostSelectionProvider)) continue;
            ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.getRootEditor().getPostSelectionChangedListener());
        }
        this.tabFolder.setSelection(0);
    }

    private int getPageCount() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            return this.tabFolder.getItemCount();
        }
        return 0;
    }

    public void addSubView(ISubView iSubView, String string, Image image) {
        super.addSubView(iSubView);
        this.tabNames.put(iSubView, string);
        this.tabImageMap.put(iSubView, image);
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        super.preferenceEventFired(preferenceEvent);
        this.fixTabControlsVisibility();
    }

    @Override
    public Control getControl() {
        return this.tabFolder;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        super.setDataInput(list);
        this.fixTabControlsVisibility();
    }

    @Override
    public void select(ISubView iSubView) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.getSubViews().size()) {
            if (Objects.equals(iSubView, this.getSubViews().get(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n > -1 && n < this.tabFolder.getItemCount()) {
            this.tabFolder.setSelection(n);
        } else {
            super.select(iSubView);
        }
    }

    @Override
    public void maximizeSubView(ISubView iSubView) {
    }

    @Override
    public void restoreMaximization() {
    }

    @Override
    public void layout() {
        this.tabFolder.layout();
    }

    private void fixTabControlsVisibility() {
        CTabItem[] cTabItemArray;
        CTabItem[] cTabItemArray2 = cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray2[n2];
            if (cTabItem.equals(this.tabFolder.getSelection())) {
                cTabItem.getControl().setVisible(true);
            } else {
                cTabItem.getControl().setVisible(false);
            }
            ++n2;
        }
    }
}

