/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.dialog;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.progress.IProgressConstants;

public class AddCmrRepositoryDefinitionDialog
extends TitleAreaDialog {
    private Text nameBox;
    private Text ipBox;
    private Text portBox;
    private Text descriptionBox;
    private CmrRepositoryDefinition cmrRepositoryDefinition = null;
    private Button okButton;

    public AddCmrRepositoryDefinitionDialog(Shell shell) {
        super(shell);
        AddCmrRepositoryDefinitionDialog.setDefaultImage((Image)InspectIT.getDefault().getImage("/icons/eclipse/wizban/server_wiz.png"));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add CMR Repository Definition");
    }

    public void create() {
        super.create();
        this.setTitle("Add CMR Repository Definition");
        this.setMessage("Define information for the repository to add", 1);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 400;
        gridData.minimumHeight = 250;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText("Server name:");
        this.nameBox = new Text(composite2, 2048);
        this.nameBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label label2 = new Label(composite2, 16384);
        label2.setText("IP Address:");
        this.ipBox = new Text(composite2, 2048);
        this.ipBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipBox.setText("localhost");
        Label label3 = new Label(composite2, 16384);
        label3.setText("Port:");
        this.portBox = new Text(composite2, 2048);
        this.portBox.setLayoutData((Object)new GridData(4, 4, false, false));
        this.portBox.setText(String.valueOf(8182));
        Label label4 = new Label(composite2, 16384);
        label4.setText("Description:");
        label4.setLayoutData((Object)new GridData(4, 128, false, false));
        this.descriptionBox = new Text(composite2, 2626);
        this.descriptionBox.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        new Label(composite2, 16384);
        final Button button = new Button(composite2, 8);
        button.setText("Test connection");
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        final BusyIndicator busyIndicator = new BusyIndicator(composite2, 0);
        busyIndicator.setLayoutData((Object)new GridData(4, 4, false, false));
        final Label label5 = new Label(composite2, 16384);
        label5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button.setEnabled(false);
                label5.setText("Testing..");
                busyIndicator.setBusy(true);
                final String string = AddCmrRepositoryDefinitionDialog.this.ipBox.getText().trim();
                final int n = Integer.parseInt(AddCmrRepositoryDefinitionDialog.this.portBox.getText());
                Job job = new Job("Checking online status.."){

                    public IStatus run(IProgressMonitor iProgressMonitor) {
                        CmrRepositoryDefinition cmrRepositoryDefinition = new CmrRepositoryDefinition(string, n);
                        boolean bl = false;
                        try {
                            cmrRepositoryDefinition.refreshOnlineStatus();
                            bl = cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE;
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                        final boolean bl2 = bl;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!busyIndicator.isDisposed() && !label5.isDisposed()) {
                                    if (busyIndicator.isBusy()) {
                                        busyIndicator.setBusy(false);
                                    }
                                    if (bl2) {
                                        label5.setText("Succeeded");
                                        busyIndicator.setImage(InspectIT.getDefault().getImage("/icons/eclipse/complete_status.gif"));
                                    } else {
                                        label5.setText("Failed");
                                        busyIndicator.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_co.gif"));
                                    }
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(false);
                job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/selfmade/server_refresh_16x16.png"));
                job.schedule();
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (AddCmrRepositoryDefinitionDialog.this.isInputValid()) {
                    AddCmrRepositoryDefinitionDialog.this.okButton.setEnabled(true);
                } else {
                    AddCmrRepositoryDefinitionDialog.this.okButton.setEnabled(false);
                }
            }
        };
        this.nameBox.addModifyListener(modifyListener);
        this.ipBox.addModifyListener(modifyListener);
        this.portBox.addModifyListener(modifyListener);
        ModifyListener modifyListener2 = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!AddCmrRepositoryDefinitionDialog.this.ipBox.getText().isEmpty() && !AddCmrRepositoryDefinitionDialog.this.portBox.getText().isEmpty()) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
                label5.setText("");
                busyIndicator.setImage(null);
                if (busyIndicator.isBusy()) {
                    busyIndicator.setBusy(false);
                }
            }
        };
        this.ipBox.addModifyListener(modifyListener2);
        this.portBox.addModifyListener(modifyListener2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, false);
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.cmrRepositoryDefinition = new CmrRepositoryDefinition(this.ipBox.getText().trim(), Integer.parseInt(this.portBox.getText()), this.nameBox.getText().trim());
            if (!this.descriptionBox.getText().trim().isEmpty()) {
                this.cmrRepositoryDefinition.setDescription(this.descriptionBox.getText().trim());
            } else {
                this.cmrRepositoryDefinition.setDescription("");
            }
        }
        super.buttonPressed(n);
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    private boolean isInputValid() {
        if (this.nameBox.getText().isEmpty()) {
            return false;
        }
        if (this.ipBox.getText().isEmpty()) {
            return false;
        }
        if (this.portBox.getText().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(this.portBox.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

