/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details;

import info.novatec.inspectit.rcp.details.DetailsCellContent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DetailsTable
extends SectionPart {
    private static final int ROW_TITLE_WIDTH_HINT = 150;
    private static final int CONTENT_CONTROL_MAX_WIDTH = 600;
    private static final int CONTENT_CONTROL_MAX_HEIGHT = 150;
    private static final int CONTENT_TABLE_MAX_HEIGHT = 200;
    private FormToolkit toolkit;
    private int columns;
    private Composite contentComposite;
    private StringBuilder copyStringBuilder = new StringBuilder();
    private GC gc;
    List<Text> textControls = new ArrayList<Text>();

    public DetailsTable(Composite composite, FormToolkit formToolkit, String string, int n) {
        super(composite, formToolkit, 322);
        this.columns = n;
        this.toolkit = formToolkit;
        this.getSection().setLayout((Layout)new TableWrapLayout());
        this.createHeading(string);
        this.copyStringBuilder.append(string);
        this.copyStringBuilder.append('\n');
        this.gc = new GC((Drawable)composite);
        this.initTable();
    }

    public void addContentRow(String string, Image image, DetailsCellContent ... detailsCellContentArray) {
        this.createRowHeading(string, image);
        if (string != null) {
            this.copyStringBuilder.append(string);
        }
        this.copyStringBuilder.append('\t');
        int n = 0;
        while (n < this.columns) {
            if (n < detailsCellContentArray.length) {
                DetailsCellContent detailsCellContent = detailsCellContentArray[n];
                String string2 = detailsCellContent.getText();
                int n2 = 0;
                boolean bl = true;
                if (string2 != null && !(bl = this.canFit(string2, 600))) {
                    n2 = this.heightHint(string2, 600, 150);
                }
                TableWrapData tableWrapData = this.getLayoutData(detailsCellContent);
                if (!bl) {
                    int n3 = 586;
                    int n4 = this.toolkit.getBorderStyle();
                    this.toolkit.setBorderStyle(0);
                    Text text = this.toolkit.createText(this.contentComposite, detailsCellContent.getText(), n3);
                    this.toolkit.setBorderStyle(n4);
                    tableWrapData.grabHorizontal = true;
                    tableWrapData.maxWidth = 600;
                    tableWrapData.maxHeight = 150;
                    tableWrapData.heightHint = n2;
                    text.setLayoutData((Object)tableWrapData);
                    this.textControls.add(text);
                } else {
                    FormText formText = this.toolkit.createFormText(this.contentComposite, false);
                    this.fillFormText(formText, detailsCellContent);
                    formText.setLayoutData((Object)tableWrapData);
                }
                if (detailsCellContent.getText() != null) {
                    this.copyStringBuilder.append(detailsCellContent.getText());
                } else if (detailsCellContent.getImageToolTip() != null) {
                    this.copyStringBuilder.append(detailsCellContent.getImageToolTip());
                }
            } else {
                this.toolkit.createLabel(this.contentComposite, "");
            }
            if (n < this.columns - 1) {
                this.copyStringBuilder.append('\t');
            }
            ++n;
        }
        this.copyStringBuilder.append('\n');
    }

    public void addContentTable(String string, Image image, int n, String[] stringArray, List<String[]> list) {
        int n2;
        this.createRowHeading(string, image);
        if (string != null) {
            this.copyStringBuilder.append(string);
        }
        Table table = this.toolkit.createTable(this.contentComposite, 0x10000B00);
        table.setHeaderVisible(true);
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = this.columns;
        tableWrapData.maxWidth = 600;
        tableWrapData.maxHeight = 200;
        table.setLayoutData((Object)tableWrapData);
        int n3 = 0;
        while (n3 < n) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setResizable(true);
            if (n3 < stringArray.length) {
                tableColumn.setText(stringArray[n3]);
            }
            ++n3;
        }
        for (String[] stringArray2 : list) {
            new TableItem(table, 0).setText(stringArray2);
            this.copyStringBuilder.append('\t');
            n2 = 0;
            while (n2 < stringArray2.length) {
                this.copyStringBuilder.append(stringArray2[n2]);
                if (n2 < stringArray2.length - 1) {
                    this.copyStringBuilder.append('\t');
                }
                ++n2;
            }
            this.copyStringBuilder.append('\n');
        }
        TableColumn[] tableColumnArray = table.getColumns();
        n2 = tableColumnArray.length;
        int n4 = 0;
        while (n4 < n2) {
            TableColumn tableColumn = tableColumnArray[n4];
            tableColumn.pack();
            ++n4;
        }
    }

    private TableWrapData getLayoutData(DetailsCellContent detailsCellContent) {
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = detailsCellContent.getColspan();
        tableWrapData.grabHorizontal = detailsCellContent.isGrab();
        return tableWrapData;
    }

    private void fillFormText(FormText formText, DetailsCellContent detailsCellContent) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form><p>");
        if (detailsCellContent.getText() != null) {
            object = StringUtils.replaceEach((String)detailsCellContent.getText(), (String[])new String[]{"<", ">", "&"}, (String[])new String[]{"&lt;", "&gt;", "&amp;"});
            stringBuilder.append((String)object);
        }
        if (detailsCellContent.getImage() != null) {
            object = new Label((Composite)formText, 0);
            object.setImage(detailsCellContent.getImage());
            if (detailsCellContent.getImageToolTip() != null) {
                object.setToolTipText(detailsCellContent.getImageToolTip());
            }
            stringBuilder.append("<control href=\"ctrl\"/>");
            formText.setControl("ctrl", (Control)object);
        }
        stringBuilder.append("</p></form>");
        formText.setText(stringBuilder.toString(), true, false);
    }

    private boolean canFit(String string, int n) {
        Point point = this.gc.textExtent(string);
        return point.x < n;
    }

    private int heightHint(String string, int n, int n2) {
        Point point = this.gc.textExtent(string);
        int n3 = point.x / (n - 50) + 1;
        return Math.min(n3 * point.y, n2);
    }

    private void initTable() {
        this.contentComposite = this.toolkit.createComposite((Composite)this.getSection());
        this.contentComposite.setLayoutData((Object)new TableWrapData(128));
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = this.columns + 1;
        tableWrapLayout.horizontalSpacing = 2;
        tableWrapLayout.verticalSpacing = 2;
        this.contentComposite.setLayout((Layout)tableWrapLayout);
        this.getSection().setClient((Control)this.contentComposite);
        this.contentComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = DetailsTable.this.contentComposite.getSize();
                int n = point.x - 150 - 20;
                for (Text text : DetailsTable.this.textControls) {
                    Object object = text.getLayoutData();
                    if (!(object instanceof TableWrapData)) continue;
                    int n2 = DetailsTable.this.heightHint(text.getText(), n, 150);
                    ((TableWrapData)object).maxWidth = n;
                    ((TableWrapData)object).heightHint = n2;
                }
            }
        });
    }

    private void createHeading(String string) {
        this.getSection().setText(string);
    }

    private void createRowHeading(String string, Image image) {
        Composite composite = this.toolkit.createComposite(this.contentComposite);
        composite.setLayoutData((Object)new TableWrapData(128));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        FormText formText = this.toolkit.createFormText(composite, false);
        if (image != null) {
            formText.setText("<form><p><img href=\"img\"/> <span color=\"headingColor\">" + string + "</span></p></form>", true, false);
            formText.setImage("img", image);
        } else {
            formText.setText("<form><p><span color=\"headingColor\">" + string + "</span></p></form>", true, false);
        }
        formText.setColor("headingColor", this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridData gridData = this.getFixedWidthGridData(150);
        gridData.verticalAlignment = 128;
        formText.setLayoutData((Object)gridData);
    }

    private GridData getFixedWidthGridData(int n) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.widthHint = n;
        return gridData;
    }

    public String getCopyString() {
        return this.copyStringBuilder.toString();
    }

    public void dispose() {
        this.gc.dispose();
        super.dispose();
    }
}

