/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.composite;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.listener.StorageChangeListener;
import info.novatec.inspectit.rcp.util.AccessibleArrowImage;
import info.novatec.inspectit.storage.IStorageData;
import java.util.Objects;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class BreadcrumbTitleComposite
extends Composite
implements CmrRepositoryChangeListener,
StorageChangeListener {
    private static final int MAX_TEXT_LENGTH = 30;
    private final Image arrow = new AccessibleArrowImage(true).createImage();
    private ToolBarManager toolBarManager;
    private RepositoryDefinition repositoryDefinition;
    private CLabel repositoryLabel;
    private CLabel agentLabel;
    private CLabel groupLabel;
    private CLabel viewLabel;

    public BreadcrumbTitleComposite(Composite composite, int n) {
        super(composite, n);
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(7, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.repositoryLabel = new CLabel(composite, 0);
        this.repositoryLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(composite, 0).setImage(this.arrow);
        this.agentLabel = new CLabel(composite, 0);
        this.agentLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(composite, 0).setImage(this.arrow);
        this.groupLabel = new CLabel(composite, 0);
        this.groupLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(composite, 0).setImage(this.arrow);
        this.viewLabel = new CLabel(composite, 0);
        this.viewLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        ToolBar toolBar = new ToolBar((Composite)this, 0x800000);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.toolBarManager = new ToolBarManager(toolBar);
    }

    public ToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
        this.repositoryLabel.setText(TextFormatter.crop(repositoryDefinition.getName(), 30));
        if (repositoryDefinition instanceof CmrRepositoryDefinition) {
            this.repositoryLabel.setImage(ImageFormatter.getCmrRepositoryImage((CmrRepositoryDefinition)repositoryDefinition, true));
            InspectIT.getDefault().getCmrRepositoryManager().addCmrRepositoryChangeListener(this);
        } else if (repositoryDefinition instanceof StorageRepositoryDefinition) {
            this.repositoryLabel.setImage(ImageFormatter.getStorageRepositoryImage((StorageRepositoryDefinition)repositoryDefinition));
            InspectIT.getDefault().getInspectITStorageManager().addStorageChangeListener(this);
        }
    }

    public void setAgent(String string, Image image) {
        this.agentLabel.setText(TextFormatter.crop(string, 30));
        this.agentLabel.setToolTipText(string);
        if (image != null) {
            this.agentLabel.setImage(image);
        }
    }

    public void setGroup(String string, Image image) {
        this.groupLabel.setText(TextFormatter.crop(string, 30));
        this.groupLabel.setToolTipText(string);
        if (image != null) {
            this.groupLabel.setImage(image);
        }
        this.layoutInternal();
    }

    public void setView(String string, Image image) {
        this.viewLabel.setText(string);
        this.viewLabel.setToolTipText(string);
        if (image != null) {
            this.viewLabel.setImage(image);
        }
        this.layoutInternal();
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (onlineStatus2 != CmrRepositoryDefinition.OnlineStatus.CHECKING && Objects.equals(this.repositoryDefinition, cmrRepositoryDefinition)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BreadcrumbTitleComposite.this.repositoryLabel.setImage(ImageFormatter.getCmrRepositoryImage((CmrRepositoryDefinition)BreadcrumbTitleComposite.this.repositoryDefinition, true));
                }
            });
        }
    }

    @Override
    public void repositoryDataUpdated(CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (Objects.equals(this.repositoryDefinition, cmrRepositoryDefinition)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BreadcrumbTitleComposite.this.repositoryLabel.setText(BreadcrumbTitleComposite.this.repositoryDefinition.getName());
                    BreadcrumbTitleComposite.this.layoutInternal();
                }
            });
        }
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
    }

    private void layoutInternal() {
        this.layout(true, true);
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void storageDataUpdated(IStorageData iStorageData) {
        this.updateStorageDetailsIfDisplayed(iStorageData);
    }

    @Override
    public void storageRemotelyDeleted(IStorageData iStorageData) {
        this.updateStorageDetailsIfDisplayed(iStorageData);
    }

    @Override
    public void storageLocallyDeleted(IStorageData iStorageData) {
        this.updateStorageDetailsIfDisplayed(iStorageData);
    }

    private void updateStorageDetailsIfDisplayed(IStorageData iStorageData) {
        StorageRepositoryDefinition storageRepositoryDefinition;
        if (this.repositoryDefinition instanceof StorageRepositoryDefinition && Objects.equals((storageRepositoryDefinition = (StorageRepositoryDefinition)this.repositoryDefinition).getLocalStorageData(), iStorageData)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BreadcrumbTitleComposite.this.repositoryLabel.setText(BreadcrumbTitleComposite.this.repositoryDefinition.getName());
                    BreadcrumbTitleComposite.this.repositoryLabel.setImage(ImageFormatter.getStorageRepositoryImage(storageRepositoryDefinition));
                    BreadcrumbTitleComposite.this.layoutInternal();
                }
            });
        }
    }

    public String getCopyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.repositoryLabel.getText());
        stringBuilder.append(" > ");
        stringBuilder.append(this.agentLabel.getText());
        if (this.groupLabel.getText() != null) {
            stringBuilder.append(" > ");
            stringBuilder.append(this.groupLabel.getText());
        }
        if (this.viewLabel.getText() != null) {
            stringBuilder.append(" > ");
            stringBuilder.append(this.viewLabel.getText());
        }
        return stringBuilder.toString();
    }

    public void dispose() {
        this.arrow.dispose();
        InspectIT.getDefault().getCmrRepositoryManager().removeCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITStorageManager().removeStorageChangeListener(this);
        super.dispose();
    }
}

