/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.job;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.ProfileEditorInput;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenProfileJob
extends Job {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private String profileId;
    private IWorkbenchPage page;

    public OpenProfileJob(CmrRepositoryDefinition cmrRepositoryDefinition, String string, IWorkbenchPage iWorkbenchPage) {
        super("Loading profile..");
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.profileId = string;
        this.page = iWorkbenchPage;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return Status.CANCEL_STATUS;
        }
        try {
            Profile profile = this.cmrRepositoryDefinition.getConfigurationInterfaceService().getProfile(this.profileId);
            final ProfileEditorInput profileEditorInput = new ProfileEditorInput(profile, this.cmrRepositoryDefinition);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpenProfileJob.this.page.openEditor((IEditorInput)profileEditorInput, "info.novatec.inspectit.rcp.ci.editor.profileEditor", true);
                    }
                    catch (PartInitException partInitException) {
                        InspectIT.getDefault().createErrorDialog("Exception occurred opening the Profile editor.", partInitException, -1);
                    }
                }
            });
            return Status.OK_STATUS;
        }
        catch (BusinessException businessException) {
            return new Status(0, "info.novatec.inspectit.rcp", "Exception occurred loading the profile from the CMR.", (Throwable)businessException);
        }
    }
}

