/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.handler;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.dialog.EditNameDescriptionDialog;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditProfileHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (structuredSelection.isEmpty()) {
            return null;
        }
        Object object = structuredSelection.getFirstElement();
        if (object instanceof IProfileProvider) {
            IProfileProvider iProfileProvider = (IProfileProvider)object;
            Profile profile = iProfileProvider.getProfile();
            CmrRepositoryDefinition cmrRepositoryDefinition = iProfileProvider.getCmrRepositoryDefinition();
            EditNameDescriptionDialog editNameDescriptionDialog = new EditNameDescriptionDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), profile.getName(), profile.getDescription(), "Edit Profile", "Enter new profile name and/or description");
            if (editNameDescriptionDialog.open() == 0) {
                profile.setName(editNameDescriptionDialog.getName());
                if (StringUtils.isNotBlank((String)editNameDescriptionDialog.getDescription())) {
                    profile.setDescription(editNameDescriptionDialog.getDescription());
                }
                try {
                    Profile profile2 = cmrRepositoryDefinition.getConfigurationInterfaceService().updateProfile(profile);
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().profileUpdated(profile2, cmrRepositoryDefinition, true);
                }
                catch (BusinessException businessException) {
                    throw new ExecutionException("Update of the profile state failed.", (Throwable)businessException);
                }
            }
        }
        return null;
    }
}

