/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.handler;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class DeleteProfileHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        boolean bl;
        final StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (structuredSelection.isEmpty()) {
            return null;
        }
        int n = structuredSelection.size();
        MessageBox messageBox = new MessageBox(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), 292);
        messageBox.setText("Confirm Delete");
        messageBox.setMessage("Are you sure you want to delete the " + n + " selected profile" + (n > 1 ? "s" : "") + "?");
        boolean bl2 = bl = 32 == messageBox.open();
        if (bl) {
            Job job = new Job("Delete Profile(s) Job"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    ArrayList<Status> arrayList = new ArrayList<Status>();
                    for (Object e : structuredSelection) {
                        if (!(e instanceof IProfileProvider)) continue;
                        CmrRepositoryDefinition cmrRepositoryDefinition = ((IProfileProvider)e).getCmrRepositoryDefinition();
                        Profile profile = ((IProfileProvider)e).getProfile();
                        try {
                            if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) continue;
                            cmrRepositoryDefinition.getConfigurationInterfaceService().deleteProfile(profile);
                            InspectIT.getDefault().getInspectITConfigurationInterfaceManager().profileDeleted(profile, cmrRepositoryDefinition);
                        }
                        catch (BusinessException businessException) {
                            arrayList.add(new Status(4, "info.novatec.inspectit.rcp", "Error deleting profile " + profile.getName() + " from the CMR.", (Throwable)businessException));
                        }
                    }
                    if (CollectionUtils.isNotEmpty(arrayList)) {
                        if (1 == arrayList.size()) {
                            return (IStatus)arrayList.iterator().next();
                        }
                        return new MultiStatus("info.novatec.inspectit.rcp", 0, (IStatus[])arrayList.toArray(new Status[arrayList.size()]), "Delete of several profiles failed.", null);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/fugue/address-book.png"));
            job.schedule();
        }
        return null;
    }
}

