/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.StringConstraintSensorConfig;
import info.novatec.inspectit.ci.sensor.exception.impl.ExceptionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.IMethodSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.HttpSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.InvocationSequenceSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.PreparedStatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.StatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.TimerSensorConfig;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SensorOptionsPart
extends SectionPart
implements IPropertyListener {
    private Environment environment;
    private Button exceptionSimple;
    private Button exceptionEnhanced;
    private List<StringConstraintComponent> constrainComponents = new ArrayList<StringConstraintComponent>();
    private FormPage formPage;

    public SensorOptionsPart(FormPage formPage, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)formPage.getEditor().getEditorInput();
        this.environment = environmentEditorInput.getEnvironment();
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.createClient(this.getSection(), formToolkit);
        this.getSection().setText("Sensor Options");
        Label label = formToolkit.createLabel((Composite)this.getSection(), "Define options for specific sensors");
        label.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.getSection().setDescriptionControl((Control)label);
    }

    private void createClient(Section section, FormToolkit formToolkit) {
        StringConstraintComponent stringConstraintComponent;
        IMethodSensorConfig iMethodSensorConfig2;
        Composite composite = formToolkit.createComposite((Composite)section);
        int n = 4;
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        IMessageManager iMessageManager = this.formPage.getManagedForm().getMessageManager();
        for (IMethodSensorConfig iMethodSensorConfig2 : this.environment.getMethodSensorConfigs()) {
            if (!(iMethodSensorConfig2 instanceof StringConstraintSensorConfig)) continue;
            stringConstraintComponent = new StringConstraintComponent((StringConstraintSensorConfig)iMethodSensorConfig2, iMessageManager);
            this.constrainComponents.add(stringConstraintComponent);
            if (iMethodSensorConfig2 instanceof TimerSensorConfig) {
                stringConstraintComponent.createComponent(composite, formToolkit, "String length of captured context(s):", "Defines the maximum string length of captured context (parameters, fields, return values) for timer sensor.", n);
                continue;
            }
            if (iMethodSensorConfig2 instanceof HttpSensorConfig) {
                stringConstraintComponent.createComponent(composite, formToolkit, "String length of captured HTTP data:", "Defines the maximum string length of captured HTTP data (parameters, headers, attributes, etc) for HTTP sensor.", n);
                continue;
            }
            if (iMethodSensorConfig2 instanceof InvocationSequenceSensorConfig) {
                stringConstraintComponent.createComponent(composite, formToolkit, "String length of captured context(s):", "Defines the maximum string length of captured context (parameters, fields, return values) for invocation sensor.", n);
                continue;
            }
            if (iMethodSensorConfig2 instanceof PreparedStatementSensorConfig) {
                stringConstraintComponent.createComponent(composite, formToolkit, "String length of SQLs:", "Defines the maximum string length of SQL strings and parameters for prepared statement sensor.", n);
                continue;
            }
            if (!(iMethodSensorConfig2 instanceof StatementSensorConfig)) continue;
            stringConstraintComponent.createComponent(composite, formToolkit, "String length of SQLs:", "Defines the maximum string length of SQL strings and parameters for statement sensor.", n);
        }
        iMethodSensorConfig2 = (ExceptionSensorConfig)this.environment.getExceptionSensorConfig();
        StringConstraintComponent stringConstraintComponent2 = new StringConstraintComponent((StringConstraintSensorConfig)iMethodSensorConfig2, iMessageManager);
        this.constrainComponents.add(stringConstraintComponent2);
        stringConstraintComponent2.createComponent(composite, formToolkit, "String length of stack trace & messages:", "Defines the maximum string length of captured stack traces and exception messages for exception sensor.", n);
        formToolkit.createLabel(composite, "Mode:").setLayoutData(SensorOptionsPart.getIndentGridData());
        stringConstraintComponent = formToolkit.createComposite(composite);
        stringConstraintComponent.setLayout(SensorOptionsPart.getLayoutForRadioGroup());
        stringConstraintComponent.setLayoutData(new GridData(4, 4, true, false));
        this.exceptionSimple = formToolkit.createButton((Composite)stringConstraintComponent, "Simple", 16);
        this.exceptionSimple.setSelection(true);
        this.exceptionSimple.setLayoutData((Object)new GridData(4, 4, true, false));
        this.exceptionEnhanced = formToolkit.createButton((Composite)stringConstraintComponent, "Enhanced", 16);
        formToolkit.createLabel(composite, "");
        SensorOptionsPart.createInfoLabel(composite, formToolkit, "Simple mode will only provide the information where have the exceptions been created. All other informations like passed and handled will be available when enhanced mode if on. But, with simple mode there will be no performance overhead for using the exception sensor.");
        this.exceptionSimple.setSelection(!iMethodSensorConfig2.isEnhanced());
        this.exceptionEnhanced.setSelection(iMethodSensorConfig2.isEnhanced());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (!SensorOptionsPart.this.isDirty()) {
                    SensorOptionsPart.this.markDirty();
                }
            }
        };
        for (StringConstraintComponent stringConstraintComponent3 : this.constrainComponents) {
            stringConstraintComponent3.addDirtyListener(listener);
        }
        this.exceptionSimple.addListener(13, listener);
        this.exceptionEnhanced.addListener(13, listener);
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            for (StringConstraintComponent stringConstraintComponent : this.constrainComponents) {
                stringConstraintComponent.validateUpdate(true);
            }
            ((ExceptionSensorConfig)this.environment.getExceptionSensorConfig()).setEnhanced(this.exceptionEnhanced.getSelection());
        }
    }

    private static Layout getLayoutForRadioGroup() {
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    private static Object getIndentGridData() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 20;
        return gridData;
    }

    private static void createInfoLabel(Composite composite, FormToolkit formToolkit, String string) {
        Label label = formToolkit.createLabel(composite, "");
        label.setToolTipText(string);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.formPage.getEditor().getEditorInput();
            this.environment = environmentEditorInput.getEnvironment();
            for (StringConstraintComponent stringConstraintComponent : this.constrainComponents) {
                for (IMethodSensorConfig iMethodSensorConfig : this.environment.getMethodSensorConfigs()) {
                    if (iMethodSensorConfig instanceof StringConstraintSensorConfig && stringConstraintComponent.updateSensorConfig((StringConstraintSensorConfig)iMethodSensorConfig)) break;
                }
                stringConstraintComponent.updateSensorConfig((StringConstraintSensorConfig)this.environment.getExceptionSensorConfig());
            }
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        super.dispose();
    }

    private static class StringConstraintComponent {
        private StringConstraintSensorConfig sensorConfig;
        private IMessageManager messageManager;
        private Button unlimited;
        private Button limited;
        private Text value;
        private ValidationControlDecoration<Text> valueDecoration;

        public StringConstraintComponent(StringConstraintSensorConfig stringConstraintSensorConfig, IMessageManager iMessageManager) {
            this.sensorConfig = stringConstraintSensorConfig;
            this.messageManager = iMessageManager;
        }

        public void createComponent(Composite composite, FormToolkit formToolkit, String string, String string2, int n) {
            FormText formText = formToolkit.createFormText(composite, false);
            formText.setText("<form><p><img href=\"img\" /> <b>" + TextFormatter.getSensorConfigName((ISensorConfig)this.sensorConfig) + "</b></p></form>", true, false);
            formText.setImage("img", ImageFormatter.getSensorConfigImage((ISensorConfig)this.sensorConfig));
            formText.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
            formToolkit.createLabel(composite, string).setLayoutData(SensorOptionsPart.getIndentGridData());
            Composite composite2 = formToolkit.createComposite(composite);
            composite2.setLayout(SensorOptionsPart.getLayoutForRadioGroup());
            composite2.setLayoutData((Object)new GridData(4, 4, true, false, n - 3, 1));
            this.unlimited = formToolkit.createButton(composite2, "Unlimited", 16);
            this.unlimited.setLayoutData((Object)new GridData(4, 4, true, false));
            this.limited = formToolkit.createButton(composite2, "Limited", 16);
            this.limited.setLayoutData((Object)new GridData(4, 4, true, false));
            this.value = formToolkit.createText(composite, "", 133120);
            this.value.setLayoutData((Object)new GridData(4, 4, true, false));
            SensorOptionsPart.createInfoLabel(composite, formToolkit, string2);
            this.valueDecoration = new ValidationControlDecoration<Text>(this.value, this.messageManager){

                @Override
                protected boolean validate(Text text) {
                    return StringConstraintComponent.this.validateUpdate(false);
                }
            };
            this.valueDecoration.setDescriptionText("Must be a positive number.");
            this.valueDecoration.registerListener(24);
            this.fillValue();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (StringConstraintComponent.this.limited.getSelection()) {
                        StringConstraintComponent.this.value.setEnabled(true);
                        StringConstraintComponent.this.value.setText(String.valueOf(StringConstraintComponent.this.sensorConfig.getStringLength()));
                    } else {
                        StringConstraintComponent.this.value.setEnabled(false);
                        StringConstraintComponent.this.value.setText("");
                    }
                }
            };
            this.unlimited.addListener(13, listener);
            this.limited.addListener(13, listener);
        }

        public void addDirtyListener(Listener listener) {
            this.unlimited.addListener(13, listener);
            this.limited.addListener(13, listener);
            this.value.addListener(24, listener);
        }

        public boolean validateUpdate(boolean bl) {
            boolean bl2 = true;
            if (this.unlimited.getSelection()) {
                if (bl) {
                    this.sensorConfig.setStringLength(0);
                }
            } else {
                try {
                    int n = Integer.parseInt(this.value.getText());
                    if (n <= 0) {
                        bl2 = false;
                    } else if (bl) {
                        this.sensorConfig.setStringLength(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
            }
            return bl2;
        }

        private void fillValue() {
            int n = this.sensorConfig.getStringLength();
            if (n > 0) {
                this.unlimited.setSelection(false);
                this.limited.setSelection(true);
                this.value.setText(String.valueOf(n));
            } else {
                this.unlimited.setSelection(true);
                this.limited.setSelection(false);
                this.value.setText("");
                this.value.setEnabled(false);
            }
        }

        public boolean updateSensorConfig(StringConstraintSensorConfig stringConstraintSensorConfig) {
            if (Objects.equals(this.sensorConfig.getClassName(), stringConstraintSensorConfig.getClassName())) {
                this.sensorConfig = stringConstraintSensorConfig;
                return true;
            }
            return false;
        }
    }
}

