/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;

public class DataSaverProcessor
extends AbstractDataProcessor {
    private static final long serialVersionUID = -5795459378970312428L;
    private List<Class<? extends DefaultData>> classes;
    private boolean writeInvocationAffiliation;

    public DataSaverProcessor() {
    }

    public DataSaverProcessor(List<Class<? extends DefaultData>> classes, boolean writeInvocationAffiliation) {
        this.classes = classes;
        if (null == this.classes) {
            this.classes = new ArrayList<Class<? extends DefaultData>>();
        }
        this.writeInvocationAffiliation = writeInvocationAffiliation;
    }

    @Override
    protected Collection<Future<Void>> processData(DefaultData defaultData) {
        if (defaultData instanceof InvocationAwareData && !this.writeInvocationAffiliation) {
            HashMap<String, Boolean> kryoPreferences = new HashMap<String, Boolean>(1);
            kryoPreferences.put("WRITE_INVOCATION_AFFILIATION_DATA", Boolean.FALSE);
            Future<Void> future = this.getStorageWriter().write(defaultData, kryoPreferences);
            if (null != future) {
                return Collections.singleton(future);
            }
        } else {
            Future<Void> future = this.getStorageWriter().write(defaultData);
            if (null != future) {
                return Collections.singleton(future);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        if (null != defaultData) {
            return this.classes.contains(defaultData.getClass());
        }
        return false;
    }
}

